package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.client.v3.ToOneRelationship;

/**
 * The Application relationships
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_ApplicationRelationships", generator = "Immutables")
public final class ApplicationRelationships
    extends org.cloudfoundry.client.v3.applications._ApplicationRelationships {
  private final ToOneRelationship space;

  private ApplicationRelationships(ApplicationRelationships.Builder builder) {
    this.space = builder.space;
  }

  /**
   * The space relationship
   */
  @JsonProperty("space")
  @Override
  public ToOneRelationship getSpace() {
    return space;
  }

  /**
   * This instance is equal to all instances of {@code ApplicationRelationships} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplicationRelationships
        && equalTo((ApplicationRelationships) another);
  }

  private boolean equalTo(ApplicationRelationships another) {
    return space.equals(another.space);
  }

  /**
   * Computes a hash code from attributes: {@code space}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + space.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ApplicationRelationships} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplicationRelationships{"
        + "space=" + space
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.applications._ApplicationRelationships {
    ToOneRelationship space;
    @JsonProperty("space")
    public void setSpace(ToOneRelationship space) {
      this.space = space;
    }
    @Override
    public ToOneRelationship getSpace() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ApplicationRelationships fromJson(Json json) {
    ApplicationRelationships.Builder builder = ApplicationRelationships.builder();
    if (json.space != null) {
      builder.space(json.space);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ApplicationRelationships ApplicationRelationships}.
   * @return A new ApplicationRelationships builder
   */
  public static ApplicationRelationships.Builder builder() {
    return new ApplicationRelationships.Builder();
  }

  /**
   * Builds instances of type {@link ApplicationRelationships ApplicationRelationships}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SPACE = 0x1L;
    private long initBits = 0x1L;

    private ToOneRelationship space;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplicationRelationships} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationRelationships instance) {
      return from((_ApplicationRelationships) instance);
    }

    /**
     * Copy abstract value type {@code _ApplicationRelationships} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ApplicationRelationships instance) {
      Objects.requireNonNull(instance, "instance");
      space(instance.getSpace());
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationRelationships#getSpace() space} attribute.
     * @param space The value for space 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space")
    public final Builder space(ToOneRelationship space) {
      this.space = Objects.requireNonNull(space, "space");
      initBits &= ~INIT_BIT_SPACE;
      return this;
    }

    /**
     * Builds a new {@link ApplicationRelationships ApplicationRelationships}.
     * @return An immutable instance of ApplicationRelationships
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplicationRelationships build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ApplicationRelationships(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SPACE) != 0) attributes.add("space");
      return "Cannot build ApplicationRelationships, some of required attributes are not set " + attributes;
    }
  }
}
