package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The response payload for the Get Application Environment operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_GetApplicationEnvironmentResponse", generator = "Immutables")
public final class GetApplicationEnvironmentResponse
    extends org.cloudfoundry.client.v3.applications._GetApplicationEnvironmentResponse {
  private final @Nullable Map<String, Object> applicationEnvironmentVariables;
  private final @Nullable Map<String, Object> environmentVariables;
  private final @Nullable Map<String, Object> runningEnvironmentVariables;
  private final @Nullable Map<String, Object> stagingEnvironmentVariables;
  private final @Nullable Map<String, Object> systemEnvironmentVariables;

  private GetApplicationEnvironmentResponse(GetApplicationEnvironmentResponse.Builder builder) {
    this.applicationEnvironmentVariables = builder.applicationEnvironmentVariables == null ? null : createUnmodifiableMap(false, false, builder.applicationEnvironmentVariables);
    this.environmentVariables = builder.environmentVariables == null ? null : createUnmodifiableMap(false, false, builder.environmentVariables);
    this.runningEnvironmentVariables = builder.runningEnvironmentVariables == null ? null : createUnmodifiableMap(false, false, builder.runningEnvironmentVariables);
    this.stagingEnvironmentVariables = builder.stagingEnvironmentVariables == null ? null : createUnmodifiableMap(false, false, builder.stagingEnvironmentVariables);
    this.systemEnvironmentVariables = builder.systemEnvironmentVariables == null ? null : createUnmodifiableMap(false, false, builder.systemEnvironmentVariables);
  }

  /**
   * The application environment variables
   */
  @JsonProperty("application_env_json")
  @Override
  public @Nullable Map<String, Object> getApplicationEnvironmentVariables() {
    return applicationEnvironmentVariables;
  }

  /**
   * The environment variables
   */
  @JsonProperty("environment_variables")
  @Override
  public @Nullable Map<String, Object> getEnvironmentVariables() {
    return environmentVariables;
  }

  /**
   * The running environment variables
   */
  @JsonProperty("running_env_json")
  @Override
  public @Nullable Map<String, Object> getRunningEnvironmentVariables() {
    return runningEnvironmentVariables;
  }

  /**
   * The staging environment variables
   */
  @JsonProperty("staging_env_json")
  @Override
  public @Nullable Map<String, Object> getStagingEnvironmentVariables() {
    return stagingEnvironmentVariables;
  }

  /**
   * The application environment variables
   */
  @JsonProperty("system_env_json")
  @Override
  public @Nullable Map<String, Object> getSystemEnvironmentVariables() {
    return systemEnvironmentVariables;
  }

  /**
   * This instance is equal to all instances of {@code GetApplicationEnvironmentResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetApplicationEnvironmentResponse
        && equalTo((GetApplicationEnvironmentResponse) another);
  }

  private boolean equalTo(GetApplicationEnvironmentResponse another) {
    return Objects.equals(applicationEnvironmentVariables, another.applicationEnvironmentVariables)
        && Objects.equals(environmentVariables, another.environmentVariables)
        && Objects.equals(runningEnvironmentVariables, another.runningEnvironmentVariables)
        && Objects.equals(stagingEnvironmentVariables, another.stagingEnvironmentVariables)
        && Objects.equals(systemEnvironmentVariables, another.systemEnvironmentVariables);
  }

  /**
   * Computes a hash code from attributes: {@code applicationEnvironmentVariables}, {@code environmentVariables}, {@code runningEnvironmentVariables}, {@code stagingEnvironmentVariables}, {@code systemEnvironmentVariables}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(applicationEnvironmentVariables);
    h += (h << 5) + Objects.hashCode(environmentVariables);
    h += (h << 5) + Objects.hashCode(runningEnvironmentVariables);
    h += (h << 5) + Objects.hashCode(stagingEnvironmentVariables);
    h += (h << 5) + Objects.hashCode(systemEnvironmentVariables);
    return h;
  }

  /**
   * Prints the immutable value {@code GetApplicationEnvironmentResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetApplicationEnvironmentResponse{"
        + "applicationEnvironmentVariables=" + applicationEnvironmentVariables
        + ", environmentVariables=" + environmentVariables
        + ", runningEnvironmentVariables=" + runningEnvironmentVariables
        + ", stagingEnvironmentVariables=" + stagingEnvironmentVariables
        + ", systemEnvironmentVariables=" + systemEnvironmentVariables
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.applications._GetApplicationEnvironmentResponse {
    Map<String, Object> applicationEnvironmentVariables = null;
    Map<String, Object> environmentVariables = null;
    Map<String, Object> runningEnvironmentVariables = null;
    Map<String, Object> stagingEnvironmentVariables = null;
    Map<String, Object> systemEnvironmentVariables = null;
    @JsonProperty("application_env_json")
    public void setApplicationEnvironmentVariables(@Nullable Map<String, Object> applicationEnvironmentVariables) {
      this.applicationEnvironmentVariables = applicationEnvironmentVariables;
    }
    @JsonProperty("environment_variables")
    public void setEnvironmentVariables(@Nullable Map<String, Object> environmentVariables) {
      this.environmentVariables = environmentVariables;
    }
    @JsonProperty("running_env_json")
    public void setRunningEnvironmentVariables(@Nullable Map<String, Object> runningEnvironmentVariables) {
      this.runningEnvironmentVariables = runningEnvironmentVariables;
    }
    @JsonProperty("staging_env_json")
    public void setStagingEnvironmentVariables(@Nullable Map<String, Object> stagingEnvironmentVariables) {
      this.stagingEnvironmentVariables = stagingEnvironmentVariables;
    }
    @JsonProperty("system_env_json")
    public void setSystemEnvironmentVariables(@Nullable Map<String, Object> systemEnvironmentVariables) {
      this.systemEnvironmentVariables = systemEnvironmentVariables;
    }
    @Override
    public Map<String, Object> getApplicationEnvironmentVariables() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getEnvironmentVariables() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getRunningEnvironmentVariables() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getStagingEnvironmentVariables() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getSystemEnvironmentVariables() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetApplicationEnvironmentResponse fromJson(Json json) {
    GetApplicationEnvironmentResponse.Builder builder = GetApplicationEnvironmentResponse.builder();
    if (json.applicationEnvironmentVariables != null) {
      builder.putAllApplicationEnvironmentVariables(json.applicationEnvironmentVariables);
    }
    if (json.environmentVariables != null) {
      builder.putAllEnvironmentVariables(json.environmentVariables);
    }
    if (json.runningEnvironmentVariables != null) {
      builder.putAllRunningEnvironmentVariables(json.runningEnvironmentVariables);
    }
    if (json.stagingEnvironmentVariables != null) {
      builder.putAllStagingEnvironmentVariables(json.stagingEnvironmentVariables);
    }
    if (json.systemEnvironmentVariables != null) {
      builder.putAllSystemEnvironmentVariables(json.systemEnvironmentVariables);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetApplicationEnvironmentResponse GetApplicationEnvironmentResponse}.
   * @return A new GetApplicationEnvironmentResponse builder
   */
  public static GetApplicationEnvironmentResponse.Builder builder() {
    return new GetApplicationEnvironmentResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetApplicationEnvironmentResponse GetApplicationEnvironmentResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Map<String, Object> applicationEnvironmentVariables = null;
    private Map<String, Object> environmentVariables = null;
    private Map<String, Object> runningEnvironmentVariables = null;
    private Map<String, Object> stagingEnvironmentVariables = null;
    private Map<String, Object> systemEnvironmentVariables = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetApplicationEnvironmentResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetApplicationEnvironmentResponse instance) {
      return from((_GetApplicationEnvironmentResponse) instance);
    }

    /**
     * Copy abstract value type {@code _GetApplicationEnvironmentResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetApplicationEnvironmentResponse instance) {
      Objects.requireNonNull(instance, "instance");
      Map<String, Object> applicationEnvironmentVariablesValue = instance.getApplicationEnvironmentVariables();
      if (applicationEnvironmentVariablesValue != null) {
        putAllApplicationEnvironmentVariables(applicationEnvironmentVariablesValue);
      }
      Map<String, Object> environmentVariablesValue = instance.getEnvironmentVariables();
      if (environmentVariablesValue != null) {
        putAllEnvironmentVariables(environmentVariablesValue);
      }
      Map<String, Object> runningEnvironmentVariablesValue = instance.getRunningEnvironmentVariables();
      if (runningEnvironmentVariablesValue != null) {
        putAllRunningEnvironmentVariables(runningEnvironmentVariablesValue);
      }
      Map<String, Object> stagingEnvironmentVariablesValue = instance.getStagingEnvironmentVariables();
      if (stagingEnvironmentVariablesValue != null) {
        putAllStagingEnvironmentVariables(stagingEnvironmentVariablesValue);
      }
      Map<String, Object> systemEnvironmentVariablesValue = instance.getSystemEnvironmentVariables();
      if (systemEnvironmentVariablesValue != null) {
        putAllSystemEnvironmentVariables(systemEnvironmentVariablesValue);
      }
      return this;
    }

    /**
     * Put one entry to the {@link GetApplicationEnvironmentResponse#getApplicationEnvironmentVariables() applicationEnvironmentVariables} map.
     * @param key The key in the applicationEnvironmentVariables map
     * @param value The associated value in the applicationEnvironmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationEnvironmentVariable(String key, Object value) {
      if (this.applicationEnvironmentVariables == null) {
        this.applicationEnvironmentVariables = new LinkedHashMap<String, Object>();
      }
      this.applicationEnvironmentVariables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GetApplicationEnvironmentResponse#getApplicationEnvironmentVariables() applicationEnvironmentVariables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationEnvironmentVariable(Map.Entry<String, ? extends Object> entry) {
      if (this.applicationEnvironmentVariables == null) {
        this.applicationEnvironmentVariables = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.applicationEnvironmentVariables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetApplicationEnvironmentResponse#getApplicationEnvironmentVariables() applicationEnvironmentVariables} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the applicationEnvironmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("application_env_json")
    public final Builder applicationEnvironmentVariables(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.applicationEnvironmentVariables = null;
        return this;
      }
      this.applicationEnvironmentVariables = new LinkedHashMap<String, Object>();
      return putAllApplicationEnvironmentVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetApplicationEnvironmentResponse#getApplicationEnvironmentVariables() applicationEnvironmentVariables} map. Nulls are not permitted
     * @param entries The entries that will be added to the applicationEnvironmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllApplicationEnvironmentVariables(Map<String, ? extends Object> entries) {
      if (this.applicationEnvironmentVariables == null) {
        this.applicationEnvironmentVariables = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.applicationEnvironmentVariables.put(k, v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link GetApplicationEnvironmentResponse#getEnvironmentVariables() environmentVariables} map.
     * @param key The key in the environmentVariables map
     * @param value The associated value in the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(String key, Object value) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, Object>();
      }
      this.environmentVariables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GetApplicationEnvironmentResponse#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(Map.Entry<String, ? extends Object> entry) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.environmentVariables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetApplicationEnvironmentResponse#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("environment_variables")
    public final Builder environmentVariables(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.environmentVariables = null;
        return this;
      }
      this.environmentVariables = new LinkedHashMap<String, Object>();
      return putAllEnvironmentVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetApplicationEnvironmentResponse#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entries The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentVariables(Map<String, ? extends Object> entries) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.environmentVariables.put(k, v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link GetApplicationEnvironmentResponse#getRunningEnvironmentVariables() runningEnvironmentVariables} map.
     * @param key The key in the runningEnvironmentVariables map
     * @param value The associated value in the runningEnvironmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder runningEnvironmentVariable(String key, Object value) {
      if (this.runningEnvironmentVariables == null) {
        this.runningEnvironmentVariables = new LinkedHashMap<String, Object>();
      }
      this.runningEnvironmentVariables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GetApplicationEnvironmentResponse#getRunningEnvironmentVariables() runningEnvironmentVariables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder runningEnvironmentVariable(Map.Entry<String, ? extends Object> entry) {
      if (this.runningEnvironmentVariables == null) {
        this.runningEnvironmentVariables = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.runningEnvironmentVariables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetApplicationEnvironmentResponse#getRunningEnvironmentVariables() runningEnvironmentVariables} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the runningEnvironmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("running_env_json")
    public final Builder runningEnvironmentVariables(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.runningEnvironmentVariables = null;
        return this;
      }
      this.runningEnvironmentVariables = new LinkedHashMap<String, Object>();
      return putAllRunningEnvironmentVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetApplicationEnvironmentResponse#getRunningEnvironmentVariables() runningEnvironmentVariables} map. Nulls are not permitted
     * @param entries The entries that will be added to the runningEnvironmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllRunningEnvironmentVariables(Map<String, ? extends Object> entries) {
      if (this.runningEnvironmentVariables == null) {
        this.runningEnvironmentVariables = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.runningEnvironmentVariables.put(k, v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link GetApplicationEnvironmentResponse#getStagingEnvironmentVariables() stagingEnvironmentVariables} map.
     * @param key The key in the stagingEnvironmentVariables map
     * @param value The associated value in the stagingEnvironmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stagingEnvironmentVariable(String key, Object value) {
      if (this.stagingEnvironmentVariables == null) {
        this.stagingEnvironmentVariables = new LinkedHashMap<String, Object>();
      }
      this.stagingEnvironmentVariables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GetApplicationEnvironmentResponse#getStagingEnvironmentVariables() stagingEnvironmentVariables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stagingEnvironmentVariable(Map.Entry<String, ? extends Object> entry) {
      if (this.stagingEnvironmentVariables == null) {
        this.stagingEnvironmentVariables = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.stagingEnvironmentVariables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetApplicationEnvironmentResponse#getStagingEnvironmentVariables() stagingEnvironmentVariables} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the stagingEnvironmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("staging_env_json")
    public final Builder stagingEnvironmentVariables(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.stagingEnvironmentVariables = null;
        return this;
      }
      this.stagingEnvironmentVariables = new LinkedHashMap<String, Object>();
      return putAllStagingEnvironmentVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetApplicationEnvironmentResponse#getStagingEnvironmentVariables() stagingEnvironmentVariables} map. Nulls are not permitted
     * @param entries The entries that will be added to the stagingEnvironmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllStagingEnvironmentVariables(Map<String, ? extends Object> entries) {
      if (this.stagingEnvironmentVariables == null) {
        this.stagingEnvironmentVariables = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.stagingEnvironmentVariables.put(k, v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link GetApplicationEnvironmentResponse#getSystemEnvironmentVariables() systemEnvironmentVariables} map.
     * @param key The key in the systemEnvironmentVariables map
     * @param value The associated value in the systemEnvironmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder systemEnvironmentVariable(String key, Object value) {
      if (this.systemEnvironmentVariables == null) {
        this.systemEnvironmentVariables = new LinkedHashMap<String, Object>();
      }
      this.systemEnvironmentVariables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GetApplicationEnvironmentResponse#getSystemEnvironmentVariables() systemEnvironmentVariables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder systemEnvironmentVariable(Map.Entry<String, ? extends Object> entry) {
      if (this.systemEnvironmentVariables == null) {
        this.systemEnvironmentVariables = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.systemEnvironmentVariables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetApplicationEnvironmentResponse#getSystemEnvironmentVariables() systemEnvironmentVariables} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the systemEnvironmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("system_env_json")
    public final Builder systemEnvironmentVariables(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.systemEnvironmentVariables = null;
        return this;
      }
      this.systemEnvironmentVariables = new LinkedHashMap<String, Object>();
      return putAllSystemEnvironmentVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetApplicationEnvironmentResponse#getSystemEnvironmentVariables() systemEnvironmentVariables} map. Nulls are not permitted
     * @param entries The entries that will be added to the systemEnvironmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllSystemEnvironmentVariables(Map<String, ? extends Object> entries) {
      if (this.systemEnvironmentVariables == null) {
        this.systemEnvironmentVariables = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.systemEnvironmentVariables.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link GetApplicationEnvironmentResponse GetApplicationEnvironmentResponse}.
     * @return An immutable instance of GetApplicationEnvironmentResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetApplicationEnvironmentResponse build() {
      return new GetApplicationEnvironmentResponse(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
