package org.cloudfoundry.client.v3.droplets;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _Buildpack}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Buildpack.builder()}.
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_Buildpack", generator = "Immutables")
public final class Buildpack extends org.cloudfoundry.client.v3.droplets._Buildpack {
  private final @Nullable String detectOutput;
  private final String name;

  private Buildpack(Buildpack.Builder builder) {
    this.detectOutput = builder.detectOutput;
    this.name = builder.name;
  }

  /**
   * The detect output from staging
   */
  @JsonProperty("detect_output")
  @Override
  public @Nullable String getDetectOutput() {
    return detectOutput;
  }

  /**
   * The name of the buildpack
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code Buildpack} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Buildpack
        && equalTo((Buildpack) another);
  }

  private boolean equalTo(Buildpack another) {
    return Objects.equals(detectOutput, another.detectOutput)
        && name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code detectOutput}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(detectOutput);
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Buildpack} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Buildpack{"
        + "detectOutput=" + detectOutput
        + ", name=" + name
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.droplets._Buildpack {
    String detectOutput;
    String name;
    @JsonProperty("detect_output")
    public void setDetectOutput(@Nullable String detectOutput) {
      this.detectOutput = detectOutput;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @Override
    public String getDetectOutput() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Buildpack fromJson(Json json) {
    Buildpack.Builder builder = Buildpack.builder();
    if (json.detectOutput != null) {
      builder.detectOutput(json.detectOutput);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Buildpack Buildpack}.
   * @return A new Buildpack builder
   */
  public static Buildpack.Builder builder() {
    return new Buildpack.Builder();
  }

  /**
   * Builds instances of type {@link Buildpack Buildpack}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String detectOutput;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Buildpack} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Buildpack instance) {
      return from((_Buildpack) instance);
    }

    /**
     * Copy abstract value type {@code _Buildpack} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Buildpack instance) {
      Objects.requireNonNull(instance, "instance");
      String detectOutputValue = instance.getDetectOutput();
      if (detectOutputValue != null) {
        detectOutput(detectOutputValue);
      }
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link Buildpack#getDetectOutput() detectOutput} attribute.
     * @param detectOutput The value for detectOutput (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("detect_output")
    public final Builder detectOutput(@Nullable String detectOutput) {
      this.detectOutput = detectOutput;
      return this;
    }

    /**
     * Initializes the value for the {@link Buildpack#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link Buildpack Buildpack}.
     * @return An immutable instance of Buildpack
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Buildpack build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Buildpack(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Buildpack, some of required attributes are not set " + attributes;
    }
  }
}
