package org.cloudfoundry.client.v3.packages;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Delete Package operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_DeletePackageRequest", generator = "Immutables")
public final class DeletePackageRequest extends org.cloudfoundry.client.v3.packages._DeletePackageRequest {
  private final String packageId;

  private DeletePackageRequest(DeletePackageRequest.Builder builder) {
    this.packageId = builder.packageId;
  }

  /**
   * The package id
   */
  @Override
  public String getPackageId() {
    return packageId;
  }

  /**
   * This instance is equal to all instances of {@code DeletePackageRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeletePackageRequest
        && equalTo((DeletePackageRequest) another);
  }

  private boolean equalTo(DeletePackageRequest another) {
    return packageId.equals(another.packageId);
  }

  /**
   * Computes a hash code from attributes: {@code packageId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + packageId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeletePackageRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeletePackageRequest{"
        + "packageId=" + packageId
        + "}";
  }

  /**
   * Creates a builder for {@link DeletePackageRequest DeletePackageRequest}.
   * @return A new DeletePackageRequest builder
   */
  public static DeletePackageRequest.Builder builder() {
    return new DeletePackageRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeletePackageRequest DeletePackageRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_PACKAGE_ID = 0x1L;
    private long initBits = 0x1L;

    private String packageId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeletePackageRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeletePackageRequest instance) {
      return from((_DeletePackageRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeletePackageRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeletePackageRequest instance) {
      Objects.requireNonNull(instance, "instance");
      packageId(instance.getPackageId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeletePackageRequest#getPackageId() packageId} attribute.
     * @param packageId The value for packageId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder packageId(String packageId) {
      this.packageId = Objects.requireNonNull(packageId, "packageId");
      initBits &= ~INIT_BIT_PACKAGE_ID;
      return this;
    }

    /**
     * Builds a new {@link DeletePackageRequest DeletePackageRequest}.
     * @return An immutable instance of DeletePackageRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeletePackageRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeletePackageRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PACKAGE_ID) != 0) attributes.add("packageId");
      return "Cannot build DeletePackageRequest, some of required attributes are not set " + attributes;
    }
  }
}
