package org.cloudfoundry.client.v3.packages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;

/**
 * The request payload for the List Packages operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_ListPackagesRequest", generator = "Immutables")
public final class ListPackagesRequest extends org.cloudfoundry.client.v3.packages._ListPackagesRequest {
  private final List<String> applicationIds;
  private final List<String> organizationIds;
  private final List<String> packageIds;
  private final List<String> spaceIds;
  private final List<PackageState> states;
  private final List<PackageType> types;
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;

  private ListPackagesRequest(ListPackagesRequest.Builder builder) {
    this.applicationIds = createUnmodifiableList(true, builder.applicationIds);
    this.organizationIds = createUnmodifiableList(true, builder.organizationIds);
    this.packageIds = createUnmodifiableList(true, builder.packageIds);
    this.spaceIds = createUnmodifiableList(true, builder.spaceIds);
    this.states = createUnmodifiableList(true, builder.states);
    this.types = createUnmodifiableList(true, builder.types);
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
  }

  /**
   * List of application ids to filter by
   */
  @Override
  public List<String> getApplicationIds() {
    return applicationIds;
  }

  /**
   * List of organization ids to filter by
   */
  @Override
  public List<String> getOrganizationIds() {
    return organizationIds;
  }

  /**
   * List of package ids to filter by
   */
  @Override
  public List<String> getPackageIds() {
    return packageIds;
  }

  /**
   * List of space ids to filter by
   */
  @Override
  public List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * List of package states to filter by
   */
  @Override
  public List<PackageState> getStates() {
    return states;
  }

  /**
   * List of package types to filter by
   */
  @Override
  public List<PackageType> getTypes() {
    return types;
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * This instance is equal to all instances of {@code ListPackagesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListPackagesRequest
        && equalTo((ListPackagesRequest) another);
  }

  private boolean equalTo(ListPackagesRequest another) {
    return applicationIds.equals(another.applicationIds)
        && organizationIds.equals(another.organizationIds)
        && packageIds.equals(another.packageIds)
        && spaceIds.equals(another.spaceIds)
        && states.equals(another.states)
        && types.equals(another.types)
        && Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage);
  }

  /**
   * Computes a hash code from attributes: {@code applicationIds}, {@code organizationIds}, {@code packageIds}, {@code spaceIds}, {@code states}, {@code types}, {@code orderBy}, {@code page}, {@code perPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationIds.hashCode();
    h += (h << 5) + organizationIds.hashCode();
    h += (h << 5) + packageIds.hashCode();
    h += (h << 5) + spaceIds.hashCode();
    h += (h << 5) + states.hashCode();
    h += (h << 5) + types.hashCode();
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListPackagesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListPackagesRequest{"
        + "applicationIds=" + applicationIds
        + ", organizationIds=" + organizationIds
        + ", packageIds=" + packageIds
        + ", spaceIds=" + spaceIds
        + ", states=" + states
        + ", types=" + types
        + ", orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListPackagesRequest ListPackagesRequest}.
   * @return A new ListPackagesRequest builder
   */
  public static ListPackagesRequest.Builder builder() {
    return new ListPackagesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListPackagesRequest ListPackagesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<String> applicationIds = new ArrayList<String>();
    private List<String> organizationIds = new ArrayList<String>();
    private List<String> packageIds = new ArrayList<String>();
    private List<String> spaceIds = new ArrayList<String>();
    private List<PackageState> states = new ArrayList<PackageState>();
    private List<PackageType> types = new ArrayList<PackageType>();
    private String orderBy;
    private Integer page;
    private Integer perPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListPackagesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListPackagesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListPackagesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListPackagesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v3.packages._ListPackagesRequest) {
        org.cloudfoundry.client.v3.packages._ListPackagesRequest instance = (org.cloudfoundry.client.v3.packages._ListPackagesRequest) object;
        addAllTypes(instance.getTypes());
        addAllSpaceIds(instance.getSpaceIds());
        addAllOrganizationIds(instance.getOrganizationIds());
        addAllPackageIds(instance.getPackageIds());
        addAllApplicationIds(instance.getApplicationIds());
        addAllStates(instance.getStates());
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Adds one element to {@link ListPackagesRequest#getApplicationIds() applicationIds} list.
     * @param element A applicationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String element) {
      this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListPackagesRequest#getApplicationIds() applicationIds} list.
     * @param elements An array of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(String... elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListPackagesRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(Iterable<String> elements) {
      this.applicationIds.clear();
      return addAllApplicationIds(elements);
    }

    /**
     * Adds elements to {@link ListPackagesRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplicationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListPackagesRequest#getOrganizationIds() organizationIds} list.
     * @param element A organizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListPackagesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An array of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(String... elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListPackagesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(Iterable<String> elements) {
      this.organizationIds.clear();
      return addAllOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link ListPackagesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListPackagesRequest#getPackageIds() packageIds} list.
     * @param element A packageIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder packageId(String element) {
      this.packageIds.add(Objects.requireNonNull(element, "packageIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListPackagesRequest#getPackageIds() packageIds} list.
     * @param elements An array of packageIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder packageIds(String... elements) {
      for (String element : elements) {
        this.packageIds.add(Objects.requireNonNull(element, "packageIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListPackagesRequest#getPackageIds() packageIds} list.
     * @param elements An iterable of packageIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder packageIds(Iterable<String> elements) {
      this.packageIds.clear();
      return addAllPackageIds(elements);
    }

    /**
     * Adds elements to {@link ListPackagesRequest#getPackageIds() packageIds} list.
     * @param elements An iterable of packageIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPackageIds(Iterable<String> elements) {
      for (String element : elements) {
        this.packageIds.add(Objects.requireNonNull(element, "packageIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListPackagesRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListPackagesRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(String... elements) {
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListPackagesRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(Iterable<String> elements) {
      this.spaceIds.clear();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link ListPackagesRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListPackagesRequest#getStates() states} list.
     * @param element A states element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(PackageState element) {
      this.states.add(Objects.requireNonNull(element, "states element"));
      return this;
    }

    /**
     * Adds elements to {@link ListPackagesRequest#getStates() states} list.
     * @param elements An array of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder states(PackageState... elements) {
      for (PackageState element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListPackagesRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder states(Iterable<? extends PackageState> elements) {
      this.states.clear();
      return addAllStates(elements);
    }

    /**
     * Adds elements to {@link ListPackagesRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStates(Iterable<? extends PackageState> elements) {
      for (PackageState element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListPackagesRequest#getTypes() types} list.
     * @param element A types element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(PackageType element) {
      this.types.add(Objects.requireNonNull(element, "types element"));
      return this;
    }

    /**
     * Adds elements to {@link ListPackagesRequest#getTypes() types} list.
     * @param elements An array of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder types(PackageType... elements) {
      for (PackageType element : elements) {
        this.types.add(Objects.requireNonNull(element, "types element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListPackagesRequest#getTypes() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder types(Iterable<? extends PackageType> elements) {
      this.types.clear();
      return addAllTypes(elements);
    }

    /**
     * Adds elements to {@link ListPackagesRequest#getTypes() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTypes(Iterable<? extends PackageType> elements) {
      for (PackageType element : elements) {
        this.types.add(Objects.requireNonNull(element, "types element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListPackagesRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListPackagesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListPackagesRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Builds a new {@link ListPackagesRequest ListPackagesRequest}.
     * @return An immutable instance of ListPackagesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListPackagesRequest build() {
      return new ListPackagesRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
