package org.cloudfoundry.client.v3.serviceInstances;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the List Shared Spaces Relationship operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_ListSharedSpacesRelationshipRequest", generator = "Immutables")
public final class ListSharedSpacesRelationshipRequest
    extends org.cloudfoundry.client.v3.serviceInstances._ListSharedSpacesRelationshipRequest {
  private final String serviceInstanceId;

  private ListSharedSpacesRelationshipRequest(ListSharedSpacesRelationshipRequest.Builder builder) {
    this.serviceInstanceId = builder.serviceInstanceId;
  }

  /**
   * The service instance id
   */
  @Override
  public String getServiceInstanceId() {
    return serviceInstanceId;
  }

  /**
   * This instance is equal to all instances of {@code ListSharedSpacesRelationshipRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListSharedSpacesRelationshipRequest
        && equalTo((ListSharedSpacesRelationshipRequest) another);
  }

  private boolean equalTo(ListSharedSpacesRelationshipRequest another) {
    return serviceInstanceId.equals(another.serviceInstanceId);
  }

  /**
   * Computes a hash code from attributes: {@code serviceInstanceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + serviceInstanceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListSharedSpacesRelationshipRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListSharedSpacesRelationshipRequest{"
        + "serviceInstanceId=" + serviceInstanceId
        + "}";
  }

  /**
   * Creates a builder for {@link ListSharedSpacesRelationshipRequest ListSharedSpacesRelationshipRequest}.
   * @return A new ListSharedSpacesRelationshipRequest builder
   */
  public static ListSharedSpacesRelationshipRequest.Builder builder() {
    return new ListSharedSpacesRelationshipRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListSharedSpacesRelationshipRequest ListSharedSpacesRelationshipRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_INSTANCE_ID = 0x1L;
    private long initBits = 0x1L;

    private String serviceInstanceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListSharedSpacesRelationshipRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListSharedSpacesRelationshipRequest instance) {
      return from((_ListSharedSpacesRelationshipRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ListSharedSpacesRelationshipRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListSharedSpacesRelationshipRequest instance) {
      Objects.requireNonNull(instance, "instance");
      serviceInstanceId(instance.getServiceInstanceId());
      return this;
    }

    /**
     * Initializes the value for the {@link ListSharedSpacesRelationshipRequest#getServiceInstanceId() serviceInstanceId} attribute.
     * @param serviceInstanceId The value for serviceInstanceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceId(String serviceInstanceId) {
      this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_ID;
      return this;
    }

    /**
     * Builds a new {@link ListSharedSpacesRelationshipRequest ListSharedSpacesRelationshipRequest}.
     * @return An immutable instance of ListSharedSpacesRelationshipRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListSharedSpacesRelationshipRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListSharedSpacesRelationshipRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_ID) != 0) attributes.add("serviceInstanceId");
      return "Cannot build ListSharedSpacesRelationshipRequest, some of required attributes are not set " + attributes;
    }
  }
}
