package org.cloudfoundry.client.v3.serviceInstances;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Unshare Service Instance operation.
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_UnshareServiceInstanceRequest", generator = "Immutables")
public final class UnshareServiceInstanceRequest
    extends org.cloudfoundry.client.v3.serviceInstances._UnshareServiceInstanceRequest {
  private final String serviceInstanceId;
  private final String spaceId;

  private UnshareServiceInstanceRequest(UnshareServiceInstanceRequest.Builder builder) {
    this.serviceInstanceId = builder.serviceInstanceId;
    this.spaceId = builder.spaceId;
  }

  /**
   * The service instance id
   */
  @Override
  public String getServiceInstanceId() {
    return serviceInstanceId;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code UnshareServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UnshareServiceInstanceRequest
        && equalTo((UnshareServiceInstanceRequest) another);
  }

  private boolean equalTo(UnshareServiceInstanceRequest another) {
    return serviceInstanceId.equals(another.serviceInstanceId)
        && spaceId.equals(another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code serviceInstanceId}, {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + serviceInstanceId.hashCode();
    h += (h << 5) + spaceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UnshareServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UnshareServiceInstanceRequest{"
        + "serviceInstanceId=" + serviceInstanceId
        + ", spaceId=" + spaceId
        + "}";
  }

  /**
   * Creates a builder for {@link UnshareServiceInstanceRequest UnshareServiceInstanceRequest}.
   * @return A new UnshareServiceInstanceRequest builder
   */
  public static UnshareServiceInstanceRequest.Builder builder() {
    return new UnshareServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link UnshareServiceInstanceRequest UnshareServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_INSTANCE_ID = 0x1L;
    private static final long INIT_BIT_SPACE_ID = 0x2L;
    private long initBits = 0x3L;

    private String serviceInstanceId;
    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UnshareServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UnshareServiceInstanceRequest instance) {
      return from((_UnshareServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UnshareServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UnshareServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      serviceInstanceId(instance.getServiceInstanceId());
      spaceId(instance.getSpaceId());
      return this;
    }

    /**
     * Initializes the value for the {@link UnshareServiceInstanceRequest#getServiceInstanceId() serviceInstanceId} attribute.
     * @param serviceInstanceId The value for serviceInstanceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceId(String serviceInstanceId) {
      this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UnshareServiceInstanceRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Builds a new {@link UnshareServiceInstanceRequest UnshareServiceInstanceRequest}.
     * @return An immutable instance of UnshareServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UnshareServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UnshareServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_ID) != 0) attributes.add("serviceInstanceId");
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build UnshareServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }
}
