package org.cloudfoundry.networking.v1.policies;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Delete Policies operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_DeletePoliciesRequest", generator = "Immutables")
public final class DeletePoliciesRequest
    extends org.cloudfoundry.networking.v1.policies._DeletePoliciesRequest {
  private final List<Policy> policies;

  private DeletePoliciesRequest(DeletePoliciesRequest.Builder builder) {
    this.policies = createUnmodifiableList(true, builder.policies);
  }

  /**
   * The policies
   */
  @JsonProperty("policies")
  @Override
  public List<Policy> getPolicies() {
    return policies;
  }

  /**
   * This instance is equal to all instances of {@code DeletePoliciesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeletePoliciesRequest
        && equalTo((DeletePoliciesRequest) another);
  }

  private boolean equalTo(DeletePoliciesRequest another) {
    return policies.equals(another.policies);
  }

  /**
   * Computes a hash code from attributes: {@code policies}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + policies.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeletePoliciesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeletePoliciesRequest{"
        + "policies=" + policies
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.networking.v1.policies._DeletePoliciesRequest {
    List<Policy> policies = Collections.emptyList();
    @JsonProperty("policies")
    public void setPolicies(List<Policy> policies) {
      this.policies = policies;
    }
    @Override
    public List<Policy> getPolicies() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static DeletePoliciesRequest fromJson(Json json) {
    DeletePoliciesRequest.Builder builder = DeletePoliciesRequest.builder();
    if (json.policies != null) {
      builder.addAllPolicies(json.policies);
    }
    return builder.build();
  }


  private static DeletePoliciesRequest validate(DeletePoliciesRequest instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link DeletePoliciesRequest DeletePoliciesRequest}.
   * @return A new DeletePoliciesRequest builder
   */
  public static DeletePoliciesRequest.Builder builder() {
    return new DeletePoliciesRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeletePoliciesRequest DeletePoliciesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<Policy> policies = new ArrayList<Policy>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeletePoliciesRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeletePoliciesRequest instance) {
      return from((_DeletePoliciesRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeletePoliciesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeletePoliciesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      addAllPolicies(instance.getPolicies());
      return this;
    }

    /**
     * Adds one element to {@link DeletePoliciesRequest#getPolicies() policies} list.
     * @param element A policies element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder policy(Policy element) {
      this.policies.add(Objects.requireNonNull(element, "policies element"));
      return this;
    }

    /**
     * Adds elements to {@link DeletePoliciesRequest#getPolicies() policies} list.
     * @param elements An array of policies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder policies(Policy... elements) {
      for (Policy element : elements) {
        this.policies.add(Objects.requireNonNull(element, "policies element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DeletePoliciesRequest#getPolicies() policies} list.
     * @param elements An iterable of policies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder policies(Iterable<? extends Policy> elements) {
      this.policies.clear();
      return addAllPolicies(elements);
    }

    /**
     * Adds elements to {@link DeletePoliciesRequest#getPolicies() policies} list.
     * @param elements An iterable of policies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPolicies(Iterable<? extends Policy> elements) {
      for (Policy element : elements) {
        this.policies.add(Objects.requireNonNull(element, "policies element"));
      }
      return this;
    }

    /**
     * Builds a new {@link DeletePoliciesRequest DeletePoliciesRequest}.
     * @return An immutable instance of DeletePoliciesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeletePoliciesRequest build() {
      return DeletePoliciesRequest.validate(new DeletePoliciesRequest(this));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
