package org.cloudfoundry.networking.v1.policies;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The payload for Router Group responses
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_Ports", generator = "Immutables")
public final class Ports extends org.cloudfoundry.networking.v1.policies._Ports {
  private final Integer end;
  private final Integer start;

  private Ports(Ports.Builder builder) {
    this.end = builder.end;
    this.start = builder.start;
  }

  /**
   * The ending port
   */
  @JsonProperty("end")
  @Override
  public Integer getEnd() {
    return end;
  }

  /**
   * The starting port
   */
  @JsonProperty("start")
  @Override
  public Integer getStart() {
    return start;
  }

  /**
   * This instance is equal to all instances of {@code Ports} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Ports
        && equalTo((Ports) another);
  }

  private boolean equalTo(Ports another) {
    return end.equals(another.end)
        && start.equals(another.start);
  }

  /**
   * Computes a hash code from attributes: {@code end}, {@code start}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + end.hashCode();
    h += (h << 5) + start.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Ports} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Ports{"
        + "end=" + end
        + ", start=" + start
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.networking.v1.policies._Ports {
    Integer end;
    Integer start;
    @JsonProperty("end")
    public void setEnd(Integer end) {
      this.end = end;
    }
    @JsonProperty("start")
    public void setStart(Integer start) {
      this.start = start;
    }
    @Override
    public Integer getEnd() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getStart() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Ports fromJson(Json json) {
    Ports.Builder builder = Ports.builder();
    if (json.end != null) {
      builder.end(json.end);
    }
    if (json.start != null) {
      builder.start(json.start);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Ports Ports}.
   * @return A new Ports builder
   */
  public static Ports.Builder builder() {
    return new Ports.Builder();
  }

  /**
   * Builds instances of type {@link Ports Ports}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_END = 0x1L;
    private static final long INIT_BIT_START = 0x2L;
    private long initBits = 0x3L;

    private Integer end;
    private Integer start;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Ports} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Ports instance) {
      return from((_Ports) instance);
    }

    /**
     * Copy abstract value type {@code _Ports} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Ports instance) {
      Objects.requireNonNull(instance, "instance");
      end(instance.getEnd());
      start(instance.getStart());
      return this;
    }

    /**
     * Initializes the value for the {@link Ports#getEnd() end} attribute.
     * @param end The value for end 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("end")
    public final Builder end(Integer end) {
      this.end = Objects.requireNonNull(end, "end");
      initBits &= ~INIT_BIT_END;
      return this;
    }

    /**
     * Initializes the value for the {@link Ports#getStart() start} attribute.
     * @param start The value for start 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("start")
    public final Builder start(Integer start) {
      this.start = Objects.requireNonNull(start, "start");
      initBits &= ~INIT_BIT_START;
      return this;
    }

    /**
     * Builds a new {@link Ports Ports}.
     * @return An immutable instance of Ports
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Ports build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Ports(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_END) != 0) attributes.add("end");
      if ((initBits & INIT_BIT_START) != 0) attributes.add("start");
      return "Cannot build Ports, some of required attributes are not set " + attributes;
    }
  }
}
