package org.cloudfoundry.routing.v1.routergroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The payload for Router Group responses
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_RouterGroup", generator = "Immutables")
public final class RouterGroup extends org.cloudfoundry.routing.v1.routergroups._RouterGroup {
  private final String name;
  private final String reservablePorts;
  private final String routerGroupId;
  private final String type;

  private RouterGroup(RouterGroup.Builder builder) {
    this.name = builder.name;
    this.reservablePorts = builder.reservablePorts;
    this.routerGroupId = builder.routerGroupId;
    this.type = builder.type;
  }

  /**
   * Name of the Router Group
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * Comma delimited list of reservable port or port ranges
   */
  @JsonProperty("reservable_ports")
  @Override
  public String getReservablePorts() {
    return reservablePorts;
  }

  /**
   * ID of the Router Group
   */
  @JsonProperty("guid")
  @Override
  public String getRouterGroupId() {
    return routerGroupId;
  }

  /**
   * Type of the router group, e.g. tcp
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code RouterGroup} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RouterGroup
        && equalTo((RouterGroup) another);
  }

  private boolean equalTo(RouterGroup another) {
    return name.equals(another.name)
        && reservablePorts.equals(another.reservablePorts)
        && routerGroupId.equals(another.routerGroupId)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code reservablePorts}, {@code routerGroupId}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + reservablePorts.hashCode();
    h += (h << 5) + routerGroupId.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RouterGroup} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RouterGroup{"
        + "name=" + name
        + ", reservablePorts=" + reservablePorts
        + ", routerGroupId=" + routerGroupId
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.routing.v1.routergroups._RouterGroup {
    String name;
    String reservablePorts;
    String routerGroupId;
    String type;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("reservable_ports")
    public void setReservablePorts(String reservablePorts) {
      this.reservablePorts = reservablePorts;
    }
    @JsonProperty("guid")
    public void setRouterGroupId(String routerGroupId) {
      this.routerGroupId = routerGroupId;
    }
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getReservablePorts() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouterGroupId() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static RouterGroup fromJson(Json json) {
    RouterGroup.Builder builder = RouterGroup.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.reservablePorts != null) {
      builder.reservablePorts(json.reservablePorts);
    }
    if (json.routerGroupId != null) {
      builder.routerGroupId(json.routerGroupId);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link RouterGroup RouterGroup}.
   * @return A new RouterGroup builder
   */
  public static RouterGroup.Builder builder() {
    return new RouterGroup.Builder();
  }

  /**
   * Builds instances of type {@link RouterGroup RouterGroup}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_RESERVABLE_PORTS = 0x2L;
    private static final long INIT_BIT_ROUTER_GROUP_ID = 0x4L;
    private static final long INIT_BIT_TYPE = 0x8L;
    private long initBits = 0xfL;

    private String name;
    private String reservablePorts;
    private String routerGroupId;
    private String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.routing.v1.routergroups.AbstractRouterGroup} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractRouterGroup instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code RouterGroup} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RouterGroup instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _RouterGroup} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_RouterGroup instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractRouterGroup) {
        AbstractRouterGroup instance = (AbstractRouterGroup) object;
        name(instance.getName());
        routerGroupId(instance.getRouterGroupId());
        type(instance.getType());
        reservablePorts(instance.getReservablePorts());
      }
    }

    /**
     * Initializes the value for the {@link RouterGroup#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link RouterGroup#getReservablePorts() reservablePorts} attribute.
     * @param reservablePorts The value for reservablePorts 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("reservable_ports")
    public final Builder reservablePorts(String reservablePorts) {
      this.reservablePorts = Objects.requireNonNull(reservablePorts, "reservablePorts");
      initBits &= ~INIT_BIT_RESERVABLE_PORTS;
      return this;
    }

    /**
     * Initializes the value for the {@link RouterGroup#getRouterGroupId() routerGroupId} attribute.
     * @param routerGroupId The value for routerGroupId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder routerGroupId(String routerGroupId) {
      this.routerGroupId = Objects.requireNonNull(routerGroupId, "routerGroupId");
      initBits &= ~INIT_BIT_ROUTER_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RouterGroup#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link RouterGroup RouterGroup}.
     * @return An immutable instance of RouterGroup
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RouterGroup build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RouterGroup(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_RESERVABLE_PORTS) != 0) attributes.add("reservablePorts");
      if ((initBits & INIT_BIT_ROUTER_GROUP_ID) != 0) attributes.add("routerGroupId");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build RouterGroup, some of required attributes are not set " + attributes;
    }
  }
}
