package org.cloudfoundry.uaa.clients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.tokens.GrantType;

/**
 * The resource in the Batch Update Clients request
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_UpdateClient", generator = "Immutables")
public final class UpdateClient extends org.cloudfoundry.uaa.clients._UpdateClient {
  private final @Nullable List<String> allowedProviders;
  private final @Nullable Boolean approvalsDeleted;
  private final @Nullable List<String> authorities;
  private final @Nullable List<GrantType> authorizedGrantTypes;
  private final @Nullable List<String> autoApproves;
  private final String clientId;
  private final @Nullable String createdWith;
  private final @Nullable String name;
  private final @Nullable List<String> redirectUriPatterns;
  private final @Nullable List<String> resourceIds;
  private final @Nullable List<String> scopes;
  private final @Nullable String tokenSalt;

  private UpdateClient(UpdateClient.Builder builder) {
    this.allowedProviders = builder.allowedProviders == null ? null : createUnmodifiableList(true, builder.allowedProviders);
    this.approvalsDeleted = builder.approvalsDeleted;
    this.authorities = builder.authorities == null ? null : createUnmodifiableList(true, builder.authorities);
    this.authorizedGrantTypes = builder.authorizedGrantTypes == null ? null : createUnmodifiableList(true, builder.authorizedGrantTypes);
    this.autoApproves = builder.autoApproves == null ? null : createUnmodifiableList(true, builder.autoApproves);
    this.clientId = builder.clientId;
    this.createdWith = builder.createdWith;
    this.name = builder.name;
    this.redirectUriPatterns = builder.redirectUriPatterns == null ? null : createUnmodifiableList(true, builder.redirectUriPatterns);
    this.resourceIds = builder.resourceIds == null ? null : createUnmodifiableList(true, builder.resourceIds);
    this.scopes = builder.scopes == null ? null : createUnmodifiableList(true, builder.scopes);
    this.tokenSalt = builder.tokenSalt;
  }

  /**
   * A list of origin keys (alias) for identity providers the client is limited to. Null implies any identity provider is allowed.
   */
  @Override
  public @Nullable List<String> getAllowedProviders() {
    return allowedProviders;
  }

  /**
   * Were the approvals deleted for the client, and an audit event sent
   */
  @Override
  public @Nullable Boolean getApprovalsDeleted() {
    return approvalsDeleted;
  }

  /**
   * Scopes that the client is able to grant when creating a client
   */
  @Override
  public @Nullable List<String> getAuthorities() {
    return authorities;
  }

  /**
   * List of grant types that can be used to obtain a token with this client. Can include authorization_code, password, implicit, and/or client_credentials.
   */
  @Override
  public @Nullable List<GrantType> getAuthorizedGrantTypes() {
    return authorizedGrantTypes;
  }

  /**
   * Scopes that do not require user approval
   */
  @Override
  public @Nullable List<String> getAutoApproves() {
    return autoApproves;
  }

  /**
   * Client identifier, unique within identity zone
   */
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * What scope the bearer token had when client was created
   */
  @Override
  public @Nullable String getCreatedWith() {
    return createdWith;
  }

  /**
   * A human readable name for the client
   */
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * Allowed URI pattern for redirect during authorization
   */
  @Override
  public @Nullable List<String> getRedirectUriPatterns() {
    return redirectUriPatterns;
  }

  /**
   * Resources the client is allowed access to
   */
  @Override
  public @Nullable List<String> getResourceIds() {
    return resourceIds;
  }

  /**
   * Scopes allowed for the client
   */
  @Override
  public @Nullable List<String> getScopes() {
    return scopes;
  }

  /**
   * A random string used to generate the client’s revokation key. Change this value to revoke all active tokens for the client
   */
  @Override
  public @Nullable String getTokenSalt() {
    return tokenSalt;
  }

  /**
   * This instance is equal to all instances of {@code UpdateClient} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateClient
        && equalTo((UpdateClient) another);
  }

  private boolean equalTo(UpdateClient another) {
    return Objects.equals(allowedProviders, another.allowedProviders)
        && Objects.equals(approvalsDeleted, another.approvalsDeleted)
        && Objects.equals(authorities, another.authorities)
        && Objects.equals(authorizedGrantTypes, another.authorizedGrantTypes)
        && Objects.equals(autoApproves, another.autoApproves)
        && clientId.equals(another.clientId)
        && Objects.equals(createdWith, another.createdWith)
        && Objects.equals(name, another.name)
        && Objects.equals(redirectUriPatterns, another.redirectUriPatterns)
        && Objects.equals(resourceIds, another.resourceIds)
        && Objects.equals(scopes, another.scopes)
        && Objects.equals(tokenSalt, another.tokenSalt);
  }

  /**
   * Computes a hash code from attributes: {@code allowedProviders}, {@code approvalsDeleted}, {@code authorities}, {@code authorizedGrantTypes}, {@code autoApproves}, {@code clientId}, {@code createdWith}, {@code name}, {@code redirectUriPatterns}, {@code resourceIds}, {@code scopes}, {@code tokenSalt}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(allowedProviders);
    h += (h << 5) + Objects.hashCode(approvalsDeleted);
    h += (h << 5) + Objects.hashCode(authorities);
    h += (h << 5) + Objects.hashCode(authorizedGrantTypes);
    h += (h << 5) + Objects.hashCode(autoApproves);
    h += (h << 5) + clientId.hashCode();
    h += (h << 5) + Objects.hashCode(createdWith);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(redirectUriPatterns);
    h += (h << 5) + Objects.hashCode(resourceIds);
    h += (h << 5) + Objects.hashCode(scopes);
    h += (h << 5) + Objects.hashCode(tokenSalt);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateClient} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateClient{"
        + "allowedProviders=" + allowedProviders
        + ", approvalsDeleted=" + approvalsDeleted
        + ", authorities=" + authorities
        + ", authorizedGrantTypes=" + authorizedGrantTypes
        + ", autoApproves=" + autoApproves
        + ", clientId=" + clientId
        + ", createdWith=" + createdWith
        + ", name=" + name
        + ", redirectUriPatterns=" + redirectUriPatterns
        + ", resourceIds=" + resourceIds
        + ", scopes=" + scopes
        + ", tokenSalt=" + tokenSalt
        + "}";
  }


  private static UpdateClient validate(UpdateClient instance) {
    instance.checkAuthorizedGrantType();
    return instance;
  }

  /**
   * Creates a builder for {@link UpdateClient UpdateClient}.
   * @return A new UpdateClient builder
   */
  public static UpdateClient.Builder builder() {
    return new UpdateClient.Builder();
  }

  /**
   * Builds instances of type {@link UpdateClient UpdateClient}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_CLIENT_ID = 0x1L;
    private long initBits = 0x1L;

    private List<String> allowedProviders = null;
    private Boolean approvalsDeleted;
    private List<String> authorities = null;
    private List<GrantType> authorizedGrantTypes = null;
    private List<String> autoApproves = null;
    private String clientId;
    private String createdWith;
    private String name;
    private List<String> redirectUriPatterns = null;
    private List<String> resourceIds = null;
    private List<String> scopes = null;
    private String tokenSalt;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.clients.AbstractUpdateClient} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractUpdateClient instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateClient} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateClient instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UpdateClient} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_UpdateClient instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractUpdateClient) {
        AbstractUpdateClient instance = (AbstractUpdateClient) object;
        List<GrantType> authorizedGrantTypesValue = instance.getAuthorizedGrantTypes();
        if (authorizedGrantTypesValue != null) {
          addAllAuthorizedGrantTypes(authorizedGrantTypesValue);
        }
        String tokenSaltValue = instance.getTokenSalt();
        if (tokenSaltValue != null) {
          tokenSalt(tokenSaltValue);
        }
        clientId(instance.getClientId());
        String createdWithValue = instance.getCreatedWith();
        if (createdWithValue != null) {
          createdWith(createdWithValue);
        }
        List<String> redirectUriPatternsValue = instance.getRedirectUriPatterns();
        if (redirectUriPatternsValue != null) {
          addAllRedirectUriPatterns(redirectUriPatternsValue);
        }
        String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        Boolean approvalsDeletedValue = instance.getApprovalsDeleted();
        if (approvalsDeletedValue != null) {
          approvalsDeleted(approvalsDeletedValue);
        }
        List<String> scopesValue = instance.getScopes();
        if (scopesValue != null) {
          addAllScopes(scopesValue);
        }
        List<String> autoApprovesValue = instance.getAutoApproves();
        if (autoApprovesValue != null) {
          addAllAutoApproves(autoApprovesValue);
        }
        List<String> allowedProvidersValue = instance.getAllowedProviders();
        if (allowedProvidersValue != null) {
          addAllAllowedProviders(allowedProvidersValue);
        }
        List<String> authoritiesValue = instance.getAuthorities();
        if (authoritiesValue != null) {
          addAllAuthorities(authoritiesValue);
        }
        List<String> resourceIdsValue = instance.getResourceIds();
        if (resourceIdsValue != null) {
          addAllResourceIds(resourceIdsValue);
        }
      }
    }

    /**
     * Adds one element to {@link UpdateClient#getAllowedProviders() allowedProviders} list.
     * @param element A allowedProviders element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedProvider(String element) {
      if (this.allowedProviders == null) {
        this.allowedProviders = new ArrayList<String>();
      }
      this.allowedProviders.add(Objects.requireNonNull(element, "allowedProviders element"));
      return this;
    }

    /**
     * Adds elements to {@link UpdateClient#getAllowedProviders() allowedProviders} list.
     * @param elements An array of allowedProviders elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedProviders(String... elements) {
      if (this.allowedProviders == null) {
        this.allowedProviders = new ArrayList<String>();
      }
      for (String element : elements) {
        this.allowedProviders.add(Objects.requireNonNull(element, "allowedProviders element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateClient#getAllowedProviders() allowedProviders} list.
     * @param elements An iterable of allowedProviders elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedProviders(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.allowedProviders = null;
        return this;
      }
      this.allowedProviders = new ArrayList<String>();
      return addAllAllowedProviders(elements);
    }

    /**
     * Adds elements to {@link UpdateClient#getAllowedProviders() allowedProviders} list.
     * @param elements An iterable of allowedProviders elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAllowedProviders(Iterable<String> elements) {
      Objects.requireNonNull(elements, "allowedProviders element");
      if (this.allowedProviders == null) {
        this.allowedProviders = new ArrayList<String>();
      }
      for (String element : elements) {
        this.allowedProviders.add(Objects.requireNonNull(element, "allowedProviders element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateClient#getApprovalsDeleted() approvalsDeleted} attribute.
     * @param approvalsDeleted The value for approvalsDeleted (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder approvalsDeleted(@Nullable Boolean approvalsDeleted) {
      this.approvalsDeleted = approvalsDeleted;
      return this;
    }

    /**
     * Adds one element to {@link UpdateClient#getAuthorities() authorities} list.
     * @param element A authorities element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authority(String element) {
      if (this.authorities == null) {
        this.authorities = new ArrayList<String>();
      }
      this.authorities.add(Objects.requireNonNull(element, "authorities element"));
      return this;
    }

    /**
     * Adds elements to {@link UpdateClient#getAuthorities() authorities} list.
     * @param elements An array of authorities elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authorities(String... elements) {
      if (this.authorities == null) {
        this.authorities = new ArrayList<String>();
      }
      for (String element : elements) {
        this.authorities.add(Objects.requireNonNull(element, "authorities element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateClient#getAuthorities() authorities} list.
     * @param elements An iterable of authorities elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authorities(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.authorities = null;
        return this;
      }
      this.authorities = new ArrayList<String>();
      return addAllAuthorities(elements);
    }

    /**
     * Adds elements to {@link UpdateClient#getAuthorities() authorities} list.
     * @param elements An iterable of authorities elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAuthorities(Iterable<String> elements) {
      Objects.requireNonNull(elements, "authorities element");
      if (this.authorities == null) {
        this.authorities = new ArrayList<String>();
      }
      for (String element : elements) {
        this.authorities.add(Objects.requireNonNull(element, "authorities element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link UpdateClient#getAuthorizedGrantTypes() authorizedGrantTypes} list.
     * @param element A authorizedGrantTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authorizedGrantType(GrantType element) {
      if (this.authorizedGrantTypes == null) {
        this.authorizedGrantTypes = new ArrayList<GrantType>();
      }
      this.authorizedGrantTypes.add(Objects.requireNonNull(element, "authorizedGrantTypes element"));
      return this;
    }

    /**
     * Adds elements to {@link UpdateClient#getAuthorizedGrantTypes() authorizedGrantTypes} list.
     * @param elements An array of authorizedGrantTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authorizedGrantTypes(GrantType... elements) {
      if (this.authorizedGrantTypes == null) {
        this.authorizedGrantTypes = new ArrayList<GrantType>();
      }
      for (GrantType element : elements) {
        this.authorizedGrantTypes.add(Objects.requireNonNull(element, "authorizedGrantTypes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateClient#getAuthorizedGrantTypes() authorizedGrantTypes} list.
     * @param elements An iterable of authorizedGrantTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authorizedGrantTypes(@Nullable Iterable<? extends GrantType> elements) {
      if (elements == null) {
        this.authorizedGrantTypes = null;
        return this;
      }
      this.authorizedGrantTypes = new ArrayList<GrantType>();
      return addAllAuthorizedGrantTypes(elements);
    }

    /**
     * Adds elements to {@link UpdateClient#getAuthorizedGrantTypes() authorizedGrantTypes} list.
     * @param elements An iterable of authorizedGrantTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAuthorizedGrantTypes(Iterable<? extends GrantType> elements) {
      Objects.requireNonNull(elements, "authorizedGrantTypes element");
      if (this.authorizedGrantTypes == null) {
        this.authorizedGrantTypes = new ArrayList<GrantType>();
      }
      for (GrantType element : elements) {
        this.authorizedGrantTypes.add(Objects.requireNonNull(element, "authorizedGrantTypes element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link UpdateClient#getAutoApproves() autoApproves} list.
     * @param element A autoApproves element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder autoApprove(String element) {
      if (this.autoApproves == null) {
        this.autoApproves = new ArrayList<String>();
      }
      this.autoApproves.add(Objects.requireNonNull(element, "autoApproves element"));
      return this;
    }

    /**
     * Adds elements to {@link UpdateClient#getAutoApproves() autoApproves} list.
     * @param elements An array of autoApproves elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder autoApproves(String... elements) {
      if (this.autoApproves == null) {
        this.autoApproves = new ArrayList<String>();
      }
      for (String element : elements) {
        this.autoApproves.add(Objects.requireNonNull(element, "autoApproves element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateClient#getAutoApproves() autoApproves} list.
     * @param elements An iterable of autoApproves elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder autoApproves(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.autoApproves = null;
        return this;
      }
      this.autoApproves = new ArrayList<String>();
      return addAllAutoApproves(elements);
    }

    /**
     * Adds elements to {@link UpdateClient#getAutoApproves() autoApproves} list.
     * @param elements An iterable of autoApproves elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAutoApproves(Iterable<String> elements) {
      Objects.requireNonNull(elements, "autoApproves element");
      if (this.autoApproves == null) {
        this.autoApproves = new ArrayList<String>();
      }
      for (String element : elements) {
        this.autoApproves.add(Objects.requireNonNull(element, "autoApproves element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateClient#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateClient#getCreatedWith() createdWith} attribute.
     * @param createdWith The value for createdWith (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder createdWith(@Nullable String createdWith) {
      this.createdWith = createdWith;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateClient#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Adds one element to {@link UpdateClient#getRedirectUriPatterns() redirectUriPatterns} list.
     * @param element A redirectUriPatterns element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder redirectUriPattern(String element) {
      if (this.redirectUriPatterns == null) {
        this.redirectUriPatterns = new ArrayList<String>();
      }
      this.redirectUriPatterns.add(Objects.requireNonNull(element, "redirectUriPatterns element"));
      return this;
    }

    /**
     * Adds elements to {@link UpdateClient#getRedirectUriPatterns() redirectUriPatterns} list.
     * @param elements An array of redirectUriPatterns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder redirectUriPatterns(String... elements) {
      if (this.redirectUriPatterns == null) {
        this.redirectUriPatterns = new ArrayList<String>();
      }
      for (String element : elements) {
        this.redirectUriPatterns.add(Objects.requireNonNull(element, "redirectUriPatterns element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateClient#getRedirectUriPatterns() redirectUriPatterns} list.
     * @param elements An iterable of redirectUriPatterns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder redirectUriPatterns(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.redirectUriPatterns = null;
        return this;
      }
      this.redirectUriPatterns = new ArrayList<String>();
      return addAllRedirectUriPatterns(elements);
    }

    /**
     * Adds elements to {@link UpdateClient#getRedirectUriPatterns() redirectUriPatterns} list.
     * @param elements An iterable of redirectUriPatterns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRedirectUriPatterns(Iterable<String> elements) {
      Objects.requireNonNull(elements, "redirectUriPatterns element");
      if (this.redirectUriPatterns == null) {
        this.redirectUriPatterns = new ArrayList<String>();
      }
      for (String element : elements) {
        this.redirectUriPatterns.add(Objects.requireNonNull(element, "redirectUriPatterns element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link UpdateClient#getResourceIds() resourceIds} list.
     * @param element A resourceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resourceId(String element) {
      if (this.resourceIds == null) {
        this.resourceIds = new ArrayList<String>();
      }
      this.resourceIds.add(Objects.requireNonNull(element, "resourceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link UpdateClient#getResourceIds() resourceIds} list.
     * @param elements An array of resourceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resourceIds(String... elements) {
      if (this.resourceIds == null) {
        this.resourceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.resourceIds.add(Objects.requireNonNull(element, "resourceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateClient#getResourceIds() resourceIds} list.
     * @param elements An iterable of resourceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resourceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.resourceIds = null;
        return this;
      }
      this.resourceIds = new ArrayList<String>();
      return addAllResourceIds(elements);
    }

    /**
     * Adds elements to {@link UpdateClient#getResourceIds() resourceIds} list.
     * @param elements An iterable of resourceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllResourceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "resourceIds element");
      if (this.resourceIds == null) {
        this.resourceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.resourceIds.add(Objects.requireNonNull(element, "resourceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link UpdateClient#getScopes() scopes} list.
     * @param element A scopes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scope(String element) {
      if (this.scopes == null) {
        this.scopes = new ArrayList<String>();
      }
      this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      return this;
    }

    /**
     * Adds elements to {@link UpdateClient#getScopes() scopes} list.
     * @param elements An array of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scopes(String... elements) {
      if (this.scopes == null) {
        this.scopes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateClient#getScopes() scopes} list.
     * @param elements An iterable of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scopes(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.scopes = null;
        return this;
      }
      this.scopes = new ArrayList<String>();
      return addAllScopes(elements);
    }

    /**
     * Adds elements to {@link UpdateClient#getScopes() scopes} list.
     * @param elements An iterable of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllScopes(Iterable<String> elements) {
      Objects.requireNonNull(elements, "scopes element");
      if (this.scopes == null) {
        this.scopes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateClient#getTokenSalt() tokenSalt} attribute.
     * @param tokenSalt The value for tokenSalt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tokenSalt(@Nullable String tokenSalt) {
      this.tokenSalt = tokenSalt;
      return this;
    }

    /**
     * Builds a new {@link UpdateClient UpdateClient}.
     * @return An immutable instance of UpdateClient
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateClient build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return UpdateClient.validate(new UpdateClient(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      return "Cannot build UpdateClient, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
