package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;

/**
 * A member of a {@link Group}
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_Member", generator = "Immutables")
public final class Member extends org.cloudfoundry.uaa.groups._Member {
  private final Entity entity;
  private final String memberId;
  private final String origin;
  private final MemberType type;

  private Member(Member.Builder builder) {
    this.entity = builder.entity;
    this.memberId = builder.memberId;
    this.origin = builder.origin;
    this.type = builder.type;
  }

  /**
   * Present only if requested with returnEntities; user or group with membership in the group
   */
  @JsonProperty("entity")
  @Override
  public Optional<Entity> getEntity() {
    return Optional.ofNullable(entity);
  }

  /**
   * Globally unique identifier of the member, either a user ID or another group ID
   */
  @JsonProperty("value")
  @Override
  public String getMemberId() {
    return memberId;
  }

  /**
   * The alias of the identity provider that authenticated this user. "uaa" is an internal UAA user.
   */
  @JsonProperty("origin")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Override
  public Optional<String> getOrigin() {
    return Optional.ofNullable(origin);
  }

  /**
   * The member type
   */
  @JsonProperty("type")
  @Override
  public Optional<MemberType> getType() {
    return Optional.ofNullable(type);
  }

  /**
   * This instance is equal to all instances of {@code Member} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Member
        && equalTo((Member) another);
  }

  private boolean equalTo(Member another) {
    return Objects.equals(entity, another.entity)
        && memberId.equals(another.memberId)
        && Objects.equals(origin, another.origin)
        && Objects.equals(type, another.type);
  }

  /**
   * Computes a hash code from attributes: {@code entity}, {@code memberId}, {@code origin}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(entity);
    h += (h << 5) + memberId.hashCode();
    h += (h << 5) + Objects.hashCode(origin);
    h += (h << 5) + Objects.hashCode(type);
    return h;
  }

  /**
   * Prints the immutable value {@code Member} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Member{");
    if (entity != null) {
      builder.append("entity=").append(entity);
    }
    if (builder.length() > 7) builder.append(", ");
    builder.append("memberId=").append(memberId);
    if (origin != null) {
      builder.append(", ");
      builder.append("origin=").append(origin);
    }
    if (type != null) {
      builder.append(", ");
      builder.append("type=").append(type);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.groups._Member {
    Optional<Entity> entity = Optional.empty();
    String memberId;
    Optional<String> origin = Optional.empty();
    Optional<MemberType> type = Optional.empty();
    @JsonProperty("entity")
    public void setEntity(Optional<Entity> entity) {
      this.entity = entity;
    }
    @JsonProperty("value")
    public void setMemberId(String memberId) {
      this.memberId = memberId;
    }
    @JsonProperty("origin")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public void setOrigin(Optional<String> origin) {
      this.origin = origin;
    }
    @JsonProperty("type")
    public void setType(Optional<MemberType> type) {
      this.type = type;
    }
    @Override
    public Optional<Entity> getEntity() { throw new UnsupportedOperationException(); }
    @Override
    public String getMemberId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getOrigin() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<MemberType> getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Member fromJson(Json json) {
    Member.Builder builder = Member.builder();
    if (json.entity != null) {
      builder.entity(json.entity);
    }
    if (json.memberId != null) {
      builder.memberId(json.memberId);
    }
    if (json.origin != null) {
      builder.origin(json.origin);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Member Member}.
   * @return A new Member builder
   */
  public static Member.Builder builder() {
    return new Member.Builder();
  }

  /**
   * Builds instances of type {@link Member Member}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_MEMBER_ID = 0x1L;
    private long initBits = 0x1L;

    private Entity entity;
    private String memberId;
    private String origin;
    private MemberType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Member} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Member instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _Member} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_Member instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.groups.AbstractMember} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractMember instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.uaa.groups._Member) {
        org.cloudfoundry.uaa.groups._Member instance = (org.cloudfoundry.uaa.groups._Member) object;
        Optional<Entity> entityOptional = instance.getEntity();
        if (entityOptional.isPresent()) {
          entity(entityOptional);
        }
      }
      if (object instanceof AbstractMember) {
        AbstractMember instance = (AbstractMember) object;
        Optional<MemberType> typeOptional = instance.getType();
        if (typeOptional.isPresent()) {
          type(typeOptional);
        }
        Optional<String> originOptional = instance.getOrigin();
        if (originOptional.isPresent()) {
          origin(originOptional);
        }
        memberId(instance.getMemberId());
      }
    }

    /**
     * Initializes the optional value {@link Member#getEntity() entity} to entity.
     * @param entity The value for entity
     * @return {@code this} builder for chained invocation
     */
    public final Builder entity(Entity entity) {
      this.entity = Objects.requireNonNull(entity, "entity");
      return this;
    }

    /**
     * Initializes the optional value {@link Member#getEntity() entity} to entity.
     * @param entity The value for entity
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("entity")
    public final Builder entity(Optional<? extends Entity> entity) {
      this.entity = entity.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link Member#getMemberId() memberId} attribute.
     * @param memberId The value for memberId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("value")
    public final Builder memberId(String memberId) {
      this.memberId = Objects.requireNonNull(memberId, "memberId");
      initBits &= ~INIT_BIT_MEMBER_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link Member#getOrigin() origin} to origin.
     * @param origin The value for origin
     * @return {@code this} builder for chained invocation
     */
    public final Builder origin(String origin) {
      this.origin = Objects.requireNonNull(origin, "origin");
      return this;
    }

    /**
     * Initializes the optional value {@link Member#getOrigin() origin} to origin.
     * @param origin The value for origin
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("origin")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public final Builder origin(Optional<String> origin) {
      this.origin = origin.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Member#getType() type} to type.
     * @param type The value for type
     * @return {@code this} builder for chained invocation
     */
    public final Builder type(MemberType type) {
      this.type = Objects.requireNonNull(type, "type");
      return this;
    }

    /**
     * Initializes the optional value {@link Member#getType() type} to type.
     * @param type The value for type
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(Optional<? extends MemberType> type) {
      this.type = type.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link Member Member}.
     * @return An immutable instance of Member
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Member build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Member(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MEMBER_ID) != 0) attributes.add("memberId");
      return "Cannot build Member, some of required attributes are not set " + attributes;
    }
  }
}
