package org.cloudfoundry.uaa.identityzones;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Get Identity Zone operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_GetIdentityZoneRequest", generator = "Immutables")
public final class GetIdentityZoneRequest extends org.cloudfoundry.uaa.identityzones._GetIdentityZoneRequest {
  private final String identityZoneId;

  private GetIdentityZoneRequest(GetIdentityZoneRequest.Builder builder) {
    this.identityZoneId = builder.identityZoneId;
  }

  /**
   * The identity zone id
   */
  @Override
  public String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * This instance is equal to all instances of {@code GetIdentityZoneRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetIdentityZoneRequest
        && equalTo((GetIdentityZoneRequest) another);
  }

  private boolean equalTo(GetIdentityZoneRequest another) {
    return identityZoneId.equals(another.identityZoneId);
  }

  /**
   * Computes a hash code from attributes: {@code identityZoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + identityZoneId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetIdentityZoneRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetIdentityZoneRequest{"
        + "identityZoneId=" + identityZoneId
        + "}";
  }

  /**
   * Creates a builder for {@link GetIdentityZoneRequest GetIdentityZoneRequest}.
   * @return A new GetIdentityZoneRequest builder
   */
  public static GetIdentityZoneRequest.Builder builder() {
    return new GetIdentityZoneRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetIdentityZoneRequest GetIdentityZoneRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_IDENTITY_ZONE_ID = 0x1L;
    private long initBits = 0x1L;

    private String identityZoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetIdentityZoneRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetIdentityZoneRequest instance) {
      return from((_GetIdentityZoneRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetIdentityZoneRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetIdentityZoneRequest instance) {
      Objects.requireNonNull(instance, "instance");
      identityZoneId(instance.getIdentityZoneId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetIdentityZoneRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(String identityZoneId) {
      this.identityZoneId = Objects.requireNonNull(identityZoneId, "identityZoneId");
      initBits &= ~INIT_BIT_IDENTITY_ZONE_ID;
      return this;
    }

    /**
     * Builds a new {@link GetIdentityZoneRequest GetIdentityZoneRequest}.
     * @return An immutable instance of GetIdentityZoneRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetIdentityZoneRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetIdentityZoneRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_IDENTITY_ZONE_ID) != 0) attributes.add("identityZoneId");
      return "Cannot build GetIdentityZoneRequest, some of required attributes are not set " + attributes;
    }
  }
}
