package org.cloudfoundry.uaa.tokens;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the get token by one-time passcode operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_GetTokenByOneTimePasscodeRequest", generator = "Immutables")
public final class GetTokenByOneTimePasscodeRequest
    extends org.cloudfoundry.uaa.tokens._GetTokenByOneTimePasscodeRequest {
  private final String clientId;
  private final String clientSecret;
  private final String passcode;
  private final @Nullable TokenFormat tokenFormat;

  private GetTokenByOneTimePasscodeRequest(GetTokenByOneTimePasscodeRequest.Builder builder) {
    this.clientId = builder.clientId;
    this.clientSecret = builder.clientSecret;
    this.passcode = builder.passcode;
    this.tokenFormat = builder.tokenFormat;
  }

  /**
   * The client identifier
   */
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * The client's secret passphrase
   */
  @Override
  public String getClientSecret() {
    return clientSecret;
  }

  /**
   * The passcode
   */
  @Override
  public String getPasscode() {
    return passcode;
  }

  /**
   * The token format
   */
  @Override
  public @Nullable TokenFormat getTokenFormat() {
    return tokenFormat;
  }

  /**
   * This instance is equal to all instances of {@code GetTokenByOneTimePasscodeRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetTokenByOneTimePasscodeRequest
        && equalTo((GetTokenByOneTimePasscodeRequest) another);
  }

  private boolean equalTo(GetTokenByOneTimePasscodeRequest another) {
    return clientId.equals(another.clientId)
        && clientSecret.equals(another.clientSecret)
        && passcode.equals(another.passcode)
        && Objects.equals(tokenFormat, another.tokenFormat);
  }

  /**
   * Computes a hash code from attributes: {@code clientId}, {@code clientSecret}, {@code passcode}, {@code tokenFormat}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + clientId.hashCode();
    h += (h << 5) + clientSecret.hashCode();
    h += (h << 5) + passcode.hashCode();
    h += (h << 5) + Objects.hashCode(tokenFormat);
    return h;
  }

  /**
   * Prints the immutable value {@code GetTokenByOneTimePasscodeRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetTokenByOneTimePasscodeRequest{"
        + "clientId=" + clientId
        + ", clientSecret=" + clientSecret
        + ", passcode=" + passcode
        + ", tokenFormat=" + tokenFormat
        + "}";
  }

  /**
   * Creates a builder for {@link GetTokenByOneTimePasscodeRequest GetTokenByOneTimePasscodeRequest}.
   * @return A new GetTokenByOneTimePasscodeRequest builder
   */
  public static GetTokenByOneTimePasscodeRequest.Builder builder() {
    return new GetTokenByOneTimePasscodeRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetTokenByOneTimePasscodeRequest GetTokenByOneTimePasscodeRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_CLIENT_ID = 0x1L;
    private static final long INIT_BIT_CLIENT_SECRET = 0x2L;
    private static final long INIT_BIT_PASSCODE = 0x4L;
    private long initBits = 0x7L;

    private String clientId;
    private String clientSecret;
    private String passcode;
    private TokenFormat tokenFormat;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetTokenByOneTimePasscodeRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetTokenByOneTimePasscodeRequest instance) {
      return from((_GetTokenByOneTimePasscodeRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetTokenByOneTimePasscodeRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetTokenByOneTimePasscodeRequest instance) {
      Objects.requireNonNull(instance, "instance");
      clientId(instance.getClientId());
      clientSecret(instance.getClientSecret());
      passcode(instance.getPasscode());
      TokenFormat tokenFormatValue = instance.getTokenFormat();
      if (tokenFormatValue != null) {
        tokenFormat(tokenFormatValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetTokenByOneTimePasscodeRequest#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link GetTokenByOneTimePasscodeRequest#getClientSecret() clientSecret} attribute.
     * @param clientSecret The value for clientSecret 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientSecret(String clientSecret) {
      this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
      initBits &= ~INIT_BIT_CLIENT_SECRET;
      return this;
    }

    /**
     * Initializes the value for the {@link GetTokenByOneTimePasscodeRequest#getPasscode() passcode} attribute.
     * @param passcode The value for passcode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder passcode(String passcode) {
      this.passcode = Objects.requireNonNull(passcode, "passcode");
      initBits &= ~INIT_BIT_PASSCODE;
      return this;
    }

    /**
     * Initializes the value for the {@link GetTokenByOneTimePasscodeRequest#getTokenFormat() tokenFormat} attribute.
     * @param tokenFormat The value for tokenFormat (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tokenFormat(@Nullable TokenFormat tokenFormat) {
      this.tokenFormat = tokenFormat;
      return this;
    }

    /**
     * Builds a new {@link GetTokenByOneTimePasscodeRequest GetTokenByOneTimePasscodeRequest}.
     * @return An immutable instance of GetTokenByOneTimePasscodeRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetTokenByOneTimePasscodeRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetTokenByOneTimePasscodeRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      if ((initBits & INIT_BIT_CLIENT_SECRET) != 0) attributes.add("clientSecret");
      if ((initBits & INIT_BIT_PASSCODE) != 0) attributes.add("passcode");
      return "Cannot build GetTokenByOneTimePasscodeRequest, some of required attributes are not set " + attributes;
    }
  }
}
