package org.cloudfoundry.uaa.tokens;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the get token by password operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_GetTokenByPasswordRequest", generator = "Immutables")
public final class GetTokenByPasswordRequest extends org.cloudfoundry.uaa.tokens._GetTokenByPasswordRequest {
  private final String clientId;
  private final String clientSecret;
  private final String password;
  private final @Nullable TokenFormat tokenFormat;
  private final String username;

  private GetTokenByPasswordRequest(GetTokenByPasswordRequest.Builder builder) {
    this.clientId = builder.clientId;
    this.clientSecret = builder.clientSecret;
    this.password = builder.password;
    this.tokenFormat = builder.tokenFormat;
    this.username = builder.username;
  }

  /**
   * The client identifier
   */
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * The client's secret passphrase
   */
  @Override
  public String getClientSecret() {
    return clientSecret;
  }

  /**
   * The password
   */
  @Override
  public String getPassword() {
    return password;
  }

  /**
   * The token format
   */
  @Override
  public @Nullable TokenFormat getTokenFormat() {
    return tokenFormat;
  }

  /**
   * The username
   */
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code GetTokenByPasswordRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetTokenByPasswordRequest
        && equalTo((GetTokenByPasswordRequest) another);
  }

  private boolean equalTo(GetTokenByPasswordRequest another) {
    return clientId.equals(another.clientId)
        && clientSecret.equals(another.clientSecret)
        && password.equals(another.password)
        && Objects.equals(tokenFormat, another.tokenFormat)
        && username.equals(another.username);
  }

  /**
   * Computes a hash code from attributes: {@code clientId}, {@code clientSecret}, {@code password}, {@code tokenFormat}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + clientId.hashCode();
    h += (h << 5) + clientSecret.hashCode();
    h += (h << 5) + password.hashCode();
    h += (h << 5) + Objects.hashCode(tokenFormat);
    h += (h << 5) + username.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetTokenByPasswordRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetTokenByPasswordRequest{"
        + "clientId=" + clientId
        + ", clientSecret=" + clientSecret
        + ", password=" + password
        + ", tokenFormat=" + tokenFormat
        + ", username=" + username
        + "}";
  }

  /**
   * Creates a builder for {@link GetTokenByPasswordRequest GetTokenByPasswordRequest}.
   * @return A new GetTokenByPasswordRequest builder
   */
  public static GetTokenByPasswordRequest.Builder builder() {
    return new GetTokenByPasswordRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetTokenByPasswordRequest GetTokenByPasswordRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_CLIENT_ID = 0x1L;
    private static final long INIT_BIT_CLIENT_SECRET = 0x2L;
    private static final long INIT_BIT_PASSWORD = 0x4L;
    private static final long INIT_BIT_USERNAME = 0x8L;
    private long initBits = 0xfL;

    private String clientId;
    private String clientSecret;
    private String password;
    private TokenFormat tokenFormat;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetTokenByPasswordRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetTokenByPasswordRequest instance) {
      return from((_GetTokenByPasswordRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetTokenByPasswordRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetTokenByPasswordRequest instance) {
      Objects.requireNonNull(instance, "instance");
      clientId(instance.getClientId());
      clientSecret(instance.getClientSecret());
      password(instance.getPassword());
      TokenFormat tokenFormatValue = instance.getTokenFormat();
      if (tokenFormatValue != null) {
        tokenFormat(tokenFormatValue);
      }
      username(instance.getUsername());
      return this;
    }

    /**
     * Initializes the value for the {@link GetTokenByPasswordRequest#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link GetTokenByPasswordRequest#getClientSecret() clientSecret} attribute.
     * @param clientSecret The value for clientSecret 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientSecret(String clientSecret) {
      this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
      initBits &= ~INIT_BIT_CLIENT_SECRET;
      return this;
    }

    /**
     * Initializes the value for the {@link GetTokenByPasswordRequest#getPassword() password} attribute.
     * @param password The value for password 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(String password) {
      this.password = Objects.requireNonNull(password, "password");
      initBits &= ~INIT_BIT_PASSWORD;
      return this;
    }

    /**
     * Initializes the value for the {@link GetTokenByPasswordRequest#getTokenFormat() tokenFormat} attribute.
     * @param tokenFormat The value for tokenFormat (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tokenFormat(@Nullable TokenFormat tokenFormat) {
      this.tokenFormat = tokenFormat;
      return this;
    }

    /**
     * Initializes the value for the {@link GetTokenByPasswordRequest#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Builds a new {@link GetTokenByPasswordRequest GetTokenByPasswordRequest}.
     * @return An immutable instance of GetTokenByPasswordRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetTokenByPasswordRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetTokenByPasswordRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      if ((initBits & INIT_BIT_CLIENT_SECRET) != 0) attributes.add("clientSecret");
      if ((initBits & INIT_BIT_PASSWORD) != 0) attributes.add("password");
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      return "Cannot build GetTokenByPasswordRequest, some of required attributes are not set " + attributes;
    }
  }
}
