package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The response from the expire password request
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_ExpirePasswordResponse", generator = "Immutables")
public final class ExpirePasswordResponse extends org.cloudfoundry.uaa.users._ExpirePasswordResponse {
  private final @Nullable Boolean locked;
  private final @Nullable Boolean passwordChangeRequired;

  private ExpirePasswordResponse(ExpirePasswordResponse.Builder builder) {
    this.locked = builder.locked;
    this.passwordChangeRequired = builder.passwordChangeRequired;
  }

  /**
   * Whether the account is locked
   */
  @JsonProperty("locked")
  @Override
  public @Nullable Boolean getLocked() {
    return locked;
  }

  /**
   * Whether user's password will be expired
   */
  @JsonProperty("passwordChangeRequired")
  @Override
  public @Nullable Boolean getPasswordChangeRequired() {
    return passwordChangeRequired;
  }

  /**
   * This instance is equal to all instances of {@code ExpirePasswordResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ExpirePasswordResponse
        && equalTo((ExpirePasswordResponse) another);
  }

  private boolean equalTo(ExpirePasswordResponse another) {
    return Objects.equals(locked, another.locked)
        && Objects.equals(passwordChangeRequired, another.passwordChangeRequired);
  }

  /**
   * Computes a hash code from attributes: {@code locked}, {@code passwordChangeRequired}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(locked);
    h += (h << 5) + Objects.hashCode(passwordChangeRequired);
    return h;
  }

  /**
   * Prints the immutable value {@code ExpirePasswordResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExpirePasswordResponse{"
        + "locked=" + locked
        + ", passwordChangeRequired=" + passwordChangeRequired
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.users._ExpirePasswordResponse {
    Boolean locked;
    Boolean passwordChangeRequired;
    @JsonProperty("locked")
    public void setLocked(@Nullable Boolean locked) {
      this.locked = locked;
    }
    @JsonProperty("passwordChangeRequired")
    public void setPasswordChangeRequired(@Nullable Boolean passwordChangeRequired) {
      this.passwordChangeRequired = passwordChangeRequired;
    }
    @Override
    public Boolean getLocked() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getPasswordChangeRequired() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ExpirePasswordResponse fromJson(Json json) {
    ExpirePasswordResponse.Builder builder = ExpirePasswordResponse.builder();
    if (json.locked != null) {
      builder.locked(json.locked);
    }
    if (json.passwordChangeRequired != null) {
      builder.passwordChangeRequired(json.passwordChangeRequired);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ExpirePasswordResponse ExpirePasswordResponse}.
   * @return A new ExpirePasswordResponse builder
   */
  public static ExpirePasswordResponse.Builder builder() {
    return new ExpirePasswordResponse.Builder();
  }

  /**
   * Builds instances of type {@link ExpirePasswordResponse ExpirePasswordResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Boolean locked;
    private Boolean passwordChangeRequired;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExpirePasswordResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExpirePasswordResponse instance) {
      return from((_ExpirePasswordResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ExpirePasswordResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ExpirePasswordResponse instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean lockedValue = instance.getLocked();
      if (lockedValue != null) {
        locked(lockedValue);
      }
      Boolean passwordChangeRequiredValue = instance.getPasswordChangeRequired();
      if (passwordChangeRequiredValue != null) {
        passwordChangeRequired(passwordChangeRequiredValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ExpirePasswordResponse#getLocked() locked} attribute.
     * @param locked The value for locked (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("locked")
    public final Builder locked(@Nullable Boolean locked) {
      this.locked = locked;
      return this;
    }

    /**
     * Initializes the value for the {@link ExpirePasswordResponse#getPasswordChangeRequired() passwordChangeRequired} attribute.
     * @param passwordChangeRequired The value for passwordChangeRequired (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("passwordChangeRequired")
    public final Builder passwordChangeRequired(@Nullable Boolean passwordChangeRequired) {
      this.passwordChangeRequired = passwordChangeRequired;
      return this;
    }

    /**
     * Builds a new {@link ExpirePasswordResponse ExpirePasswordResponse}.
     * @return An immutable instance of ExpirePasswordResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ExpirePasswordResponse build() {
      return new ExpirePasswordResponse(this);
    }
  }
}
