/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.applications.NetInfoPorts;
import org.cloudfoundry.client.v2.applications._NetInfo;
import org.immutables.value.Generated;

@Generated(from="_NetInfo", generator="Immutables")
public final class NetInfo
extends _NetInfo {
    @Nullable
    private final String address;
    @Nullable
    private final List<NetInfoPorts> ports;

    private NetInfo(Builder builder) {
        this.address = builder.address;
        this.ports = builder.ports == null ? null : NetInfo.createUnmodifiableList(true, builder.ports);
    }

    @Override
    @JsonProperty(value="address")
    @Nullable
    public String getAddress() {
        return this.address;
    }

    @Override
    @JsonProperty(value="ports")
    @Nullable
    public List<NetInfoPorts> getPorts() {
        return this.ports;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof NetInfo && this.equalTo((NetInfo)another);
    }

    private boolean equalTo(NetInfo another) {
        return Objects.equals(this.address, another.address) && Objects.equals(this.ports, another.ports);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.address);
        h += (h << 5) + Objects.hashCode(this.ports);
        return h;
    }

    public String toString() {
        return "NetInfo{address=" + this.address + ", ports=" + this.ports + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static NetInfo fromJson(Json json) {
        Builder builder = NetInfo.builder();
        if (json.address != null) {
            builder.address(json.address);
        }
        if (json.ports != null) {
            builder.addAllPorts(json.ports);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private String address;
        private List<NetInfoPorts> ports = null;

        private Builder() {
        }

        public final Builder from(NetInfo instance) {
            return this.from((_NetInfo)instance);
        }

        final Builder from(_NetInfo instance) {
            List<NetInfoPorts> portsValue;
            Objects.requireNonNull(instance, "instance");
            String addressValue = instance.getAddress();
            if (addressValue != null) {
                this.address(addressValue);
            }
            if ((portsValue = instance.getPorts()) != null) {
                this.addAllPorts(portsValue);
            }
            return this;
        }

        @JsonProperty(value="address")
        public final Builder address(@Nullable String address) {
            this.address = address;
            return this;
        }

        public final Builder port(NetInfoPorts element) {
            if (this.ports == null) {
                this.ports = new ArrayList<NetInfoPorts>();
            }
            this.ports.add(Objects.requireNonNull(element, "ports element"));
            return this;
        }

        public final Builder ports(NetInfoPorts ... elements) {
            if (this.ports == null) {
                this.ports = new ArrayList<NetInfoPorts>();
            }
            for (NetInfoPorts element : elements) {
                this.ports.add(Objects.requireNonNull(element, "ports element"));
            }
            return this;
        }

        @JsonProperty(value="ports")
        public final Builder ports(@Nullable Iterable<? extends NetInfoPorts> elements) {
            if (elements == null) {
                this.ports = null;
                return this;
            }
            this.ports = new ArrayList<NetInfoPorts>();
            return this.addAllPorts(elements);
        }

        public final Builder addAllPorts(Iterable<? extends NetInfoPorts> elements) {
            Objects.requireNonNull(elements, "ports element");
            if (this.ports == null) {
                this.ports = new ArrayList<NetInfoPorts>();
            }
            for (NetInfoPorts netInfoPorts : elements) {
                this.ports.add(Objects.requireNonNull(netInfoPorts, "ports element"));
            }
            return this;
        }

        public NetInfo build() {
            return new NetInfo(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _NetInfo {
        String address;
        List<NetInfoPorts> ports = null;

        Json() {
        }

        @JsonProperty(value="address")
        public void setAddress(@Nullable String address) {
            this.address = address;
        }

        @JsonProperty(value="ports")
        public void setPorts(@Nullable List<NetInfoPorts> ports) {
            this.ports = ports;
        }

        @Override
        public String getAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<NetInfoPorts> getPorts() {
            throw new UnsupportedOperationException();
        }
    }
}

