/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v2.applications._NetInfoPorts;
import org.immutables.value.Generated;

@Generated(from="_NetInfoPorts", generator="Immutables")
public final class NetInfoPorts
extends _NetInfoPorts {
    private final Integer containerPort;
    private final Integer hostPort;

    private NetInfoPorts(Builder builder) {
        this.containerPort = builder.containerPort;
        this.hostPort = builder.hostPort;
    }

    @Override
    @JsonProperty(value="container_port")
    public Integer getContainerPort() {
        return this.containerPort;
    }

    @Override
    @JsonProperty(value="host_port")
    public Integer getHostPort() {
        return this.hostPort;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof NetInfoPorts && this.equalTo((NetInfoPorts)another);
    }

    private boolean equalTo(NetInfoPorts another) {
        return this.containerPort.equals(another.containerPort) && this.hostPort.equals(another.hostPort);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.containerPort.hashCode();
        h += (h << 5) + this.hostPort.hashCode();
        return h;
    }

    public String toString() {
        return "NetInfoPorts{containerPort=" + this.containerPort + ", hostPort=" + this.hostPort + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static NetInfoPorts fromJson(Json json) {
        Builder builder = NetInfoPorts.builder();
        if (json.containerPort != null) {
            builder.containerPort(json.containerPort);
        }
        if (json.hostPort != null) {
            builder.hostPort(json.hostPort);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CONTAINER_PORT = 1L;
        private static final long INIT_BIT_HOST_PORT = 2L;
        private long initBits = 3L;
        private Integer containerPort;
        private Integer hostPort;

        private Builder() {
        }

        public final Builder from(NetInfoPorts instance) {
            return this.from((_NetInfoPorts)instance);
        }

        final Builder from(_NetInfoPorts instance) {
            Objects.requireNonNull(instance, "instance");
            this.containerPort(instance.getContainerPort());
            this.hostPort(instance.getHostPort());
            return this;
        }

        @JsonProperty(value="container_port")
        public final Builder containerPort(Integer containerPort) {
            this.containerPort = Objects.requireNonNull(containerPort, "containerPort");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="host_port")
        public final Builder hostPort(Integer hostPort) {
            this.hostPort = Objects.requireNonNull(hostPort, "hostPort");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public NetInfoPorts build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new NetInfoPorts(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("containerPort");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hostPort");
            }
            return "Cannot build NetInfoPorts, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _NetInfoPorts {
        Integer containerPort;
        Integer hostPort;

        Json() {
        }

        @JsonProperty(value="container_port")
        public void setContainerPort(Integer containerPort) {
            this.containerPort = containerPort;
        }

        @JsonProperty(value="host_port")
        public void setHostPort(Integer hostPort) {
            this.hostPort = hostPort;
        }

        @Override
        public Integer getContainerPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getHostPort() {
            throw new UnsupportedOperationException();
        }
    }
}

