/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.domains;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.domains._ListDomainSpacesRequest;
import org.immutables.value.Generated;

@Generated(from="_ListDomainSpacesRequest", generator="Immutables")
public final class ListDomainSpacesRequest
extends _ListDomainSpacesRequest {
    @Nullable
    private final List<String> applicationIds;
    @Nullable
    private final List<String> developerIds;
    private final String domainId;
    @Nullable
    private final List<String> names;
    @Nullable
    private final List<String> organizationIds;
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;

    private ListDomainSpacesRequest(Builder builder) {
        this.applicationIds = builder.applicationIds == null ? null : ListDomainSpacesRequest.createUnmodifiableList(true, builder.applicationIds);
        this.developerIds = builder.developerIds == null ? null : ListDomainSpacesRequest.createUnmodifiableList(true, builder.developerIds);
        this.domainId = builder.domainId;
        this.names = builder.names == null ? null : ListDomainSpacesRequest.createUnmodifiableList(true, builder.names);
        this.organizationIds = builder.organizationIds == null ? null : ListDomainSpacesRequest.createUnmodifiableList(true, builder.organizationIds);
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
    }

    @Override
    @Nullable
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    @Override
    @Nullable
    public List<String> getDeveloperIds() {
        return this.developerIds;
    }

    @Override
    public String getDomainId() {
        return this.domainId;
    }

    @Override
    @Nullable
    public List<String> getNames() {
        return this.names;
    }

    @Override
    @Nullable
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListDomainSpacesRequest && this.equalTo((ListDomainSpacesRequest)another);
    }

    private boolean equalTo(ListDomainSpacesRequest another) {
        return Objects.equals(this.applicationIds, another.applicationIds) && Objects.equals(this.developerIds, another.developerIds) && this.domainId.equals(another.domainId) && Objects.equals(this.names, another.names) && Objects.equals(this.organizationIds, another.organizationIds) && Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.applicationIds);
        h += (h << 5) + Objects.hashCode(this.developerIds);
        h += (h << 5) + this.domainId.hashCode();
        h += (h << 5) + Objects.hashCode(this.names);
        h += (h << 5) + Objects.hashCode(this.organizationIds);
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        return h;
    }

    public String toString() {
        return "ListDomainSpacesRequest{applicationIds=" + this.applicationIds + ", developerIds=" + this.developerIds + ", domainId=" + this.domainId + ", names=" + this.names + ", organizationIds=" + this.organizationIds + ", orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_DOMAIN_ID = 1L;
        private long initBits = 1L;
        private List<String> applicationIds = null;
        private List<String> developerIds = null;
        private String domainId;
        private List<String> names = null;
        private List<String> organizationIds = null;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListDomainSpacesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ListDomainSpacesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListDomainSpacesRequest) {
                List<String> organizationIdsValue;
                List<String> namesValue;
                instance = (_ListDomainSpacesRequest)object;
                List<String> developerIdsValue = ((_ListDomainSpacesRequest)instance).getDeveloperIds();
                if (developerIdsValue != null) {
                    this.addAllDeveloperIds(developerIdsValue);
                }
                if ((namesValue = ((_ListDomainSpacesRequest)instance).getNames()) != null) {
                    this.addAllNames(namesValue);
                }
                if ((organizationIdsValue = ((_ListDomainSpacesRequest)instance).getOrganizationIds()) != null) {
                    this.addAllOrganizationIds(organizationIdsValue);
                }
                this.domainId(((_ListDomainSpacesRequest)instance).getDomainId());
                List<String> applicationIdsValue = ((_ListDomainSpacesRequest)instance).getApplicationIds();
                if (applicationIdsValue != null) {
                    this.addAllApplicationIds(applicationIdsValue);
                }
            }
        }

        public final Builder applicationId(String element) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList<String>();
            }
            this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            return this;
        }

        public final Builder applicationIds(String ... elements) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder applicationIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.applicationIds = null;
                return this;
            }
            this.applicationIds = new ArrayList<String>();
            return this.addAllApplicationIds(elements);
        }

        public final Builder addAllApplicationIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "applicationIds element");
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder developerId(String element) {
            if (this.developerIds == null) {
                this.developerIds = new ArrayList<String>();
            }
            this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
            return this;
        }

        public final Builder developerIds(String ... elements) {
            if (this.developerIds == null) {
                this.developerIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
            }
            return this;
        }

        public final Builder developerIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.developerIds = null;
                return this;
            }
            this.developerIds = new ArrayList<String>();
            return this.addAllDeveloperIds(elements);
        }

        public final Builder addAllDeveloperIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "developerIds element");
            if (this.developerIds == null) {
                this.developerIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
            }
            return this;
        }

        public final Builder domainId(String domainId) {
            this.domainId = Objects.requireNonNull(domainId, "domainId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String element) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder names(String ... elements) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.names = null;
                return this;
            }
            this.names = new ArrayList<String>();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            Objects.requireNonNull(elements, "names element");
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder organizationId(String element) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList<String>();
            }
            this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            return this;
        }

        public final Builder organizationIds(String ... elements) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder organizationIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.organizationIds = null;
                return this;
            }
            this.organizationIds = new ArrayList<String>();
            return this.addAllOrganizationIds(elements);
        }

        public final Builder addAllOrganizationIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "organizationIds element");
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListDomainSpacesRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListDomainSpacesRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("domainId");
            }
            return "Cannot build ListDomainSpacesRequest, some of required attributes are not set " + attributes;
        }
    }
}

