/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.organizations._CreateOrganizationRequest;
import org.immutables.value.Generated;

@Generated(from="_CreateOrganizationRequest", generator="Immutables")
public final class CreateOrganizationRequest
extends _CreateOrganizationRequest {
    private final String name;
    @Nullable
    private final String quotaDefinitionId;
    @Nullable
    private final String status;

    private CreateOrganizationRequest(Builder builder) {
        this.name = builder.name;
        this.quotaDefinitionId = builder.quotaDefinitionId;
        this.status = builder.status;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="quota_definition_guid")
    @Nullable
    public String getQuotaDefinitionId() {
        return this.quotaDefinitionId;
    }

    @Override
    @JsonProperty(value="status")
    @Nullable
    public String getStatus() {
        return this.status;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateOrganizationRequest && this.equalTo((CreateOrganizationRequest)another);
    }

    private boolean equalTo(CreateOrganizationRequest another) {
        return this.name.equals(another.name) && Objects.equals(this.quotaDefinitionId, another.quotaDefinitionId) && Objects.equals(this.status, another.status);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.quotaDefinitionId);
        h += (h << 5) + Objects.hashCode(this.status);
        return h;
    }

    public String toString() {
        return "CreateOrganizationRequest{name=" + this.name + ", quotaDefinitionId=" + this.quotaDefinitionId + ", status=" + this.status + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CreateOrganizationRequest fromJson(Json json) {
        Builder builder = CreateOrganizationRequest.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.quotaDefinitionId != null) {
            builder.quotaDefinitionId(json.quotaDefinitionId);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private String name;
        private String quotaDefinitionId;
        private String status;

        private Builder() {
        }

        public final Builder from(CreateOrganizationRequest instance) {
            return this.from((_CreateOrganizationRequest)instance);
        }

        final Builder from(_CreateOrganizationRequest instance) {
            String statusValue;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            String quotaDefinitionIdValue = instance.getQuotaDefinitionId();
            if (quotaDefinitionIdValue != null) {
                this.quotaDefinitionId(quotaDefinitionIdValue);
            }
            if ((statusValue = instance.getStatus()) != null) {
                this.status(statusValue);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder quotaDefinitionId(@Nullable String quotaDefinitionId) {
            this.quotaDefinitionId = quotaDefinitionId;
            return this;
        }

        public final Builder status(@Nullable String status) {
            this.status = status;
            return this;
        }

        public CreateOrganizationRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateOrganizationRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build CreateOrganizationRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _CreateOrganizationRequest {
        String name;
        String quotaDefinitionId;
        String status;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="quota_definition_guid")
        public void setQuotaDefinitionId(@Nullable String quotaDefinitionId) {
            this.quotaDefinitionId = quotaDefinitionId;
        }

        @JsonProperty(value="status")
        public void setStatus(@Nullable String status) {
            this.status = status;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getQuotaDefinitionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStatus() {
            throw new UnsupportedOperationException();
        }
    }
}

