/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.services;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.services._ServiceEntity;
import org.immutables.value.Generated;

@Generated(from="_ServiceEntity", generator="Immutables")
public final class ServiceEntity
extends _ServiceEntity {
    @Nullable
    private final Boolean active;
    @Nullable
    private final Boolean bindable;
    @Nullable
    private final String description;
    @Nullable
    private final String documentationUrl;
    @Nullable
    private final String extra;
    @Nullable
    private final String infoUrl;
    @Nullable
    private final String label;
    @Nullable
    private final String longDescription;
    @Nullable
    private final Boolean planUpdateable;
    @Nullable
    private final String provider;
    @Nullable
    private final List<String> requires;
    @Nullable
    private final String serviceBrokerId;
    @Nullable
    private final String servicePlansUrl;
    @Nullable
    private final List<String> tags;
    @Nullable
    private final String uniqueId;
    @Nullable
    private final String url;
    @Nullable
    private final String version;

    private ServiceEntity(Builder builder) {
        this.active = builder.active;
        this.bindable = builder.bindable;
        this.description = builder.description;
        this.documentationUrl = builder.documentationUrl;
        this.extra = builder.extra;
        this.infoUrl = builder.infoUrl;
        this.label = builder.label;
        this.longDescription = builder.longDescription;
        this.planUpdateable = builder.planUpdateable;
        this.provider = builder.provider;
        this.requires = builder.requires == null ? null : ServiceEntity.createUnmodifiableList(true, builder.requires);
        this.serviceBrokerId = builder.serviceBrokerId;
        this.servicePlansUrl = builder.servicePlansUrl;
        this.tags = builder.tags == null ? null : ServiceEntity.createUnmodifiableList(true, builder.tags);
        this.uniqueId = builder.uniqueId;
        this.url = builder.url;
        this.version = builder.version;
    }

    @Override
    @JsonProperty(value="active")
    @Nullable
    public Boolean getActive() {
        return this.active;
    }

    @Override
    @JsonProperty(value="bindable")
    @Nullable
    public Boolean getBindable() {
        return this.bindable;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="documentation_url")
    @Deprecated
    @Nullable
    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    @Override
    @JsonProperty(value="extra")
    @Nullable
    public String getExtra() {
        return this.extra;
    }

    @Override
    @JsonProperty(value="info_url")
    @Deprecated
    @Nullable
    public String getInfoUrl() {
        return this.infoUrl;
    }

    @Override
    @JsonProperty(value="label")
    @Nullable
    public String getLabel() {
        return this.label;
    }

    @Override
    @JsonProperty(value="long_description")
    @Deprecated
    @Nullable
    public String getLongDescription() {
        return this.longDescription;
    }

    @Override
    @JsonProperty(value="plan_updateable")
    @Nullable
    public Boolean getPlanUpdateable() {
        return this.planUpdateable;
    }

    @Override
    @JsonProperty(value="provider")
    @Deprecated
    @Nullable
    public String getProvider() {
        return this.provider;
    }

    @Override
    @JsonProperty(value="requires")
    @Nullable
    public List<String> getRequires() {
        return this.requires;
    }

    @Override
    @JsonProperty(value="service_broker_guid")
    @Nullable
    public String getServiceBrokerId() {
        return this.serviceBrokerId;
    }

    @Override
    @JsonProperty(value="service_plans_url")
    @Nullable
    public String getServicePlansUrl() {
        return this.servicePlansUrl;
    }

    @Override
    @JsonProperty(value="tags")
    @Nullable
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="unique_id")
    @Nullable
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    @JsonProperty(value="url")
    @Deprecated
    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Override
    @JsonProperty(value="version")
    @Deprecated
    @Nullable
    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ServiceEntity && this.equalTo((ServiceEntity)another);
    }

    private boolean equalTo(ServiceEntity another) {
        return Objects.equals(this.active, another.active) && Objects.equals(this.bindable, another.bindable) && Objects.equals(this.description, another.description) && Objects.equals(this.documentationUrl, another.documentationUrl) && Objects.equals(this.extra, another.extra) && Objects.equals(this.infoUrl, another.infoUrl) && Objects.equals(this.label, another.label) && Objects.equals(this.longDescription, another.longDescription) && Objects.equals(this.planUpdateable, another.planUpdateable) && Objects.equals(this.provider, another.provider) && Objects.equals(this.requires, another.requires) && Objects.equals(this.serviceBrokerId, another.serviceBrokerId) && Objects.equals(this.servicePlansUrl, another.servicePlansUrl) && Objects.equals(this.tags, another.tags) && Objects.equals(this.uniqueId, another.uniqueId) && Objects.equals(this.url, another.url) && Objects.equals(this.version, another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.active);
        h += (h << 5) + Objects.hashCode(this.bindable);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.documentationUrl);
        h += (h << 5) + Objects.hashCode(this.extra);
        h += (h << 5) + Objects.hashCode(this.infoUrl);
        h += (h << 5) + Objects.hashCode(this.label);
        h += (h << 5) + Objects.hashCode(this.longDescription);
        h += (h << 5) + Objects.hashCode(this.planUpdateable);
        h += (h << 5) + Objects.hashCode(this.provider);
        h += (h << 5) + Objects.hashCode(this.requires);
        h += (h << 5) + Objects.hashCode(this.serviceBrokerId);
        h += (h << 5) + Objects.hashCode(this.servicePlansUrl);
        h += (h << 5) + Objects.hashCode(this.tags);
        h += (h << 5) + Objects.hashCode(this.uniqueId);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.version);
        return h;
    }

    public String toString() {
        return "ServiceEntity{active=" + this.active + ", bindable=" + this.bindable + ", description=" + this.description + ", documentationUrl=" + this.documentationUrl + ", extra=" + this.extra + ", infoUrl=" + this.infoUrl + ", label=" + this.label + ", longDescription=" + this.longDescription + ", planUpdateable=" + this.planUpdateable + ", provider=" + this.provider + ", requires=" + this.requires + ", serviceBrokerId=" + this.serviceBrokerId + ", servicePlansUrl=" + this.servicePlansUrl + ", tags=" + this.tags + ", uniqueId=" + this.uniqueId + ", url=" + this.url + ", version=" + this.version + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ServiceEntity fromJson(Json json) {
        Builder builder = ServiceEntity.builder();
        if (json.active != null) {
            builder.active(json.active);
        }
        if (json.bindable != null) {
            builder.bindable(json.bindable);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.documentationUrl != null) {
            builder.documentationUrl(json.documentationUrl);
        }
        if (json.extra != null) {
            builder.extra(json.extra);
        }
        if (json.infoUrl != null) {
            builder.infoUrl(json.infoUrl);
        }
        if (json.label != null) {
            builder.label(json.label);
        }
        if (json.longDescription != null) {
            builder.longDescription(json.longDescription);
        }
        if (json.planUpdateable != null) {
            builder.planUpdateable(json.planUpdateable);
        }
        if (json.provider != null) {
            builder.provider(json.provider);
        }
        if (json.requires != null) {
            builder.addAllRequires(json.requires);
        }
        if (json.serviceBrokerId != null) {
            builder.serviceBrokerId(json.serviceBrokerId);
        }
        if (json.servicePlansUrl != null) {
            builder.servicePlansUrl(json.servicePlansUrl);
        }
        if (json.tags != null) {
            builder.addAllTags(json.tags);
        }
        if (json.uniqueId != null) {
            builder.uniqueId(json.uniqueId);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private Boolean active;
        private Boolean bindable;
        private String description;
        private String documentationUrl;
        private String extra;
        private String infoUrl;
        private String label;
        private String longDescription;
        private Boolean planUpdateable;
        private String provider;
        private List<String> requires = null;
        private String serviceBrokerId;
        private String servicePlansUrl;
        private List<String> tags = null;
        private String uniqueId;
        private String url;
        private String version;

        private Builder() {
        }

        public final Builder from(ServiceEntity instance) {
            return this.from((_ServiceEntity)instance);
        }

        final Builder from(_ServiceEntity instance) {
            String versionValue;
            String urlValue;
            String uniqueIdValue;
            List<String> tagsValue;
            String servicePlansUrlValue;
            String serviceBrokerIdValue;
            List<String> requiresValue;
            String providerValue;
            Boolean planUpdateableValue;
            String longDescriptionValue;
            String labelValue;
            String infoUrlValue;
            String extraValue;
            String documentationUrlValue;
            String descriptionValue;
            Boolean bindableValue;
            Objects.requireNonNull(instance, "instance");
            Boolean activeValue = instance.getActive();
            if (activeValue != null) {
                this.active(activeValue);
            }
            if ((bindableValue = instance.getBindable()) != null) {
                this.bindable(bindableValue);
            }
            if ((descriptionValue = instance.getDescription()) != null) {
                this.description(descriptionValue);
            }
            if ((documentationUrlValue = instance.getDocumentationUrl()) != null) {
                this.documentationUrl(documentationUrlValue);
            }
            if ((extraValue = instance.getExtra()) != null) {
                this.extra(extraValue);
            }
            if ((infoUrlValue = instance.getInfoUrl()) != null) {
                this.infoUrl(infoUrlValue);
            }
            if ((labelValue = instance.getLabel()) != null) {
                this.label(labelValue);
            }
            if ((longDescriptionValue = instance.getLongDescription()) != null) {
                this.longDescription(longDescriptionValue);
            }
            if ((planUpdateableValue = instance.getPlanUpdateable()) != null) {
                this.planUpdateable(planUpdateableValue);
            }
            if ((providerValue = instance.getProvider()) != null) {
                this.provider(providerValue);
            }
            if ((requiresValue = instance.getRequires()) != null) {
                this.addAllRequires(requiresValue);
            }
            if ((serviceBrokerIdValue = instance.getServiceBrokerId()) != null) {
                this.serviceBrokerId(serviceBrokerIdValue);
            }
            if ((servicePlansUrlValue = instance.getServicePlansUrl()) != null) {
                this.servicePlansUrl(servicePlansUrlValue);
            }
            if ((tagsValue = instance.getTags()) != null) {
                this.addAllTags(tagsValue);
            }
            if ((uniqueIdValue = instance.getUniqueId()) != null) {
                this.uniqueId(uniqueIdValue);
            }
            if ((urlValue = instance.getUrl()) != null) {
                this.url(urlValue);
            }
            if ((versionValue = instance.getVersion()) != null) {
                this.version(versionValue);
            }
            return this;
        }

        @JsonProperty(value="active")
        public final Builder active(@Nullable Boolean active) {
            this.active = active;
            return this;
        }

        @JsonProperty(value="bindable")
        public final Builder bindable(@Nullable Boolean bindable) {
            this.bindable = bindable;
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="documentation_url")
        @Deprecated
        public final Builder documentationUrl(@Nullable String documentationUrl) {
            this.documentationUrl = documentationUrl;
            return this;
        }

        @JsonProperty(value="extra")
        public final Builder extra(@Nullable String extra) {
            this.extra = extra;
            return this;
        }

        @JsonProperty(value="info_url")
        @Deprecated
        public final Builder infoUrl(@Nullable String infoUrl) {
            this.infoUrl = infoUrl;
            return this;
        }

        @JsonProperty(value="label")
        public final Builder label(@Nullable String label) {
            this.label = label;
            return this;
        }

        @JsonProperty(value="long_description")
        @Deprecated
        public final Builder longDescription(@Nullable String longDescription) {
            this.longDescription = longDescription;
            return this;
        }

        @JsonProperty(value="plan_updateable")
        public final Builder planUpdateable(@Nullable Boolean planUpdateable) {
            this.planUpdateable = planUpdateable;
            return this;
        }

        @JsonProperty(value="provider")
        @Deprecated
        public final Builder provider(@Nullable String provider) {
            this.provider = provider;
            return this;
        }

        public final Builder require(String element) {
            if (this.requires == null) {
                this.requires = new ArrayList<String>();
            }
            this.requires.add(Objects.requireNonNull(element, "requires element"));
            return this;
        }

        public final Builder requires(String ... elements) {
            if (this.requires == null) {
                this.requires = new ArrayList<String>();
            }
            for (String element : elements) {
                this.requires.add(Objects.requireNonNull(element, "requires element"));
            }
            return this;
        }

        @JsonProperty(value="requires")
        public final Builder requires(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.requires = null;
                return this;
            }
            this.requires = new ArrayList<String>();
            return this.addAllRequires(elements);
        }

        public final Builder addAllRequires(Iterable<String> elements) {
            Objects.requireNonNull(elements, "requires element");
            if (this.requires == null) {
                this.requires = new ArrayList<String>();
            }
            for (String element : elements) {
                this.requires.add(Objects.requireNonNull(element, "requires element"));
            }
            return this;
        }

        @JsonProperty(value="service_broker_guid")
        public final Builder serviceBrokerId(@Nullable String serviceBrokerId) {
            this.serviceBrokerId = serviceBrokerId;
            return this;
        }

        @JsonProperty(value="service_plans_url")
        public final Builder servicePlansUrl(@Nullable String servicePlansUrl) {
            this.servicePlansUrl = servicePlansUrl;
            return this;
        }

        public final Builder tag(String element) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            this.tags.add(Objects.requireNonNull(element, "tags element"));
            return this;
        }

        public final Builder tags(String ... elements) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        @JsonProperty(value="tags")
        public final Builder tags(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.tags = null;
                return this;
            }
            this.tags = new ArrayList<String>();
            return this.addAllTags(elements);
        }

        public final Builder addAllTags(Iterable<String> elements) {
            Objects.requireNonNull(elements, "tags element");
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        @JsonProperty(value="unique_id")
        public final Builder uniqueId(@Nullable String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        @JsonProperty(value="url")
        @Deprecated
        public final Builder url(@Nullable String url) {
            this.url = url;
            return this;
        }

        @JsonProperty(value="version")
        @Deprecated
        public final Builder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        public ServiceEntity build() {
            return new ServiceEntity(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _ServiceEntity {
        Boolean active;
        Boolean bindable;
        String description;
        String documentationUrl;
        String extra;
        String infoUrl;
        String label;
        String longDescription;
        Boolean planUpdateable;
        String provider;
        List<String> requires = null;
        String serviceBrokerId;
        String servicePlansUrl;
        List<String> tags = null;
        String uniqueId;
        String url;
        String version;

        Json() {
        }

        @JsonProperty(value="active")
        public void setActive(@Nullable Boolean active) {
            this.active = active;
        }

        @JsonProperty(value="bindable")
        public void setBindable(@Nullable Boolean bindable) {
            this.bindable = bindable;
        }

        @JsonProperty(value="description")
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @JsonProperty(value="documentation_url")
        public void setDocumentationUrl(@Nullable String documentationUrl) {
            this.documentationUrl = documentationUrl;
        }

        @JsonProperty(value="extra")
        public void setExtra(@Nullable String extra) {
            this.extra = extra;
        }

        @JsonProperty(value="info_url")
        public void setInfoUrl(@Nullable String infoUrl) {
            this.infoUrl = infoUrl;
        }

        @JsonProperty(value="label")
        public void setLabel(@Nullable String label) {
            this.label = label;
        }

        @JsonProperty(value="long_description")
        public void setLongDescription(@Nullable String longDescription) {
            this.longDescription = longDescription;
        }

        @JsonProperty(value="plan_updateable")
        public void setPlanUpdateable(@Nullable Boolean planUpdateable) {
            this.planUpdateable = planUpdateable;
        }

        @JsonProperty(value="provider")
        public void setProvider(@Nullable String provider) {
            this.provider = provider;
        }

        @JsonProperty(value="requires")
        public void setRequires(@Nullable List<String> requires) {
            this.requires = requires;
        }

        @JsonProperty(value="service_broker_guid")
        public void setServiceBrokerId(@Nullable String serviceBrokerId) {
            this.serviceBrokerId = serviceBrokerId;
        }

        @JsonProperty(value="service_plans_url")
        public void setServicePlansUrl(@Nullable String servicePlansUrl) {
            this.servicePlansUrl = servicePlansUrl;
        }

        @JsonProperty(value="tags")
        public void setTags(@Nullable List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="unique_id")
        public void setUniqueId(@Nullable String uniqueId) {
            this.uniqueId = uniqueId;
        }

        @JsonProperty(value="url")
        public void setUrl(@Nullable String url) {
            this.url = url;
        }

        @JsonProperty(value="version")
        public void setVersion(@Nullable String version) {
            this.version = version;
        }

        @Override
        public Boolean getActive() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getBindable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDocumentationUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getExtra() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getInfoUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLabel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLongDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getPlanUpdateable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getProvider() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getRequires() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceBrokerId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServicePlansUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUniqueId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getVersion() {
            throw new UnsupportedOperationException();
        }
    }
}

