/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ProcessState {
    CRASHED("CRASHED"),
    DOWN("down"),
    RUNNING("RUNNING"),
    STARTING("starting");

    private final String value;

    private ProcessState(String value) {
        this.value = value;
    }

    @JsonCreator
    public static ProcessState from(String s) {
        switch (s.toLowerCase()) {
            case "crashed": {
                return CRASHED;
            }
            case "down": {
                return DOWN;
            }
            case "running": {
                return RUNNING;
            }
            case "starting": {
                return STARTING;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown process state: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

