/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.serviceInstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v3.Relationship;
import org.cloudfoundry.client.v3.serviceInstances._ShareServiceInstanceRequest;
import org.immutables.value.Generated;

@Generated(from="_ShareServiceInstanceRequest", generator="Immutables")
public final class ShareServiceInstanceRequest
extends _ShareServiceInstanceRequest {
    private final List<Relationship> data;
    private final String serviceInstanceId;

    private ShareServiceInstanceRequest(Builder builder) {
        this.data = ShareServiceInstanceRequest.createUnmodifiableList(true, builder.data);
        this.serviceInstanceId = builder.serviceInstanceId;
    }

    @Override
    @JsonProperty(value="data")
    public List<Relationship> getData() {
        return this.data;
    }

    @Override
    @JsonProperty(value="serviceInstanceId")
    @JsonIgnore
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ShareServiceInstanceRequest && this.equalTo((ShareServiceInstanceRequest)another);
    }

    private boolean equalTo(ShareServiceInstanceRequest another) {
        return this.data.equals(another.data) && this.serviceInstanceId.equals(another.serviceInstanceId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.data.hashCode();
        h += (h << 5) + this.serviceInstanceId.hashCode();
        return h;
    }

    public String toString() {
        return "ShareServiceInstanceRequest{data=" + this.data + ", serviceInstanceId=" + this.serviceInstanceId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ShareServiceInstanceRequest fromJson(Json json) {
        Builder builder = ShareServiceInstanceRequest.builder();
        if (json.data != null) {
            builder.addAllData(json.data);
        }
        if (json.serviceInstanceId != null) {
            builder.serviceInstanceId(json.serviceInstanceId);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_SERVICE_INSTANCE_ID = 1L;
        private long initBits = 1L;
        private List<Relationship> data = new ArrayList<Relationship>();
        private String serviceInstanceId;

        private Builder() {
        }

        public final Builder from(ShareServiceInstanceRequest instance) {
            return this.from((_ShareServiceInstanceRequest)instance);
        }

        final Builder from(_ShareServiceInstanceRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllData(instance.getData());
            this.serviceInstanceId(instance.getServiceInstanceId());
            return this;
        }

        public final Builder data(Relationship element) {
            this.data.add(Objects.requireNonNull(element, "data element"));
            return this;
        }

        public final Builder data(Relationship ... elements) {
            for (Relationship element : elements) {
                this.data.add(Objects.requireNonNull(element, "data element"));
            }
            return this;
        }

        public final Builder data(Iterable<? extends Relationship> elements) {
            this.data.clear();
            return this.addAllData(elements);
        }

        public final Builder addAllData(Iterable<? extends Relationship> elements) {
            for (Relationship relationship : elements) {
                this.data.add(Objects.requireNonNull(relationship, "data element"));
            }
            return this;
        }

        public final Builder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ShareServiceInstanceRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ShareServiceInstanceRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("serviceInstanceId");
            }
            return "Cannot build ShareServiceInstanceRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _ShareServiceInstanceRequest {
        List<Relationship> data = Collections.emptyList();
        String serviceInstanceId;

        Json() {
        }

        @JsonProperty(value="data")
        public void setData(List<Relationship> data) {
            this.data = data;
        }

        @JsonProperty(value="serviceInstanceId")
        @JsonIgnore
        public void setServiceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
        }

        @Override
        public List<Relationship> getData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceInstanceId() {
            throw new UnsupportedOperationException();
        }
    }
}

