/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.cloudfoundry.uaa.groups.AbstractMember;
import org.cloudfoundry.uaa.groups.MemberType;
import org.cloudfoundry.uaa.groups._AddMemberResponse;
import org.immutables.value.Generated;

@Generated(from="_AddMemberResponse", generator="Immutables")
public final class AddMemberResponse
extends _AddMemberResponse {
    private final String memberId;
    private final String origin;
    private final MemberType type;

    private AddMemberResponse(Builder builder) {
        this.memberId = builder.memberId;
        this.origin = builder.origin;
        this.type = builder.type;
    }

    @Override
    @JsonProperty(value="value")
    public String getMemberId() {
        return this.memberId;
    }

    @Override
    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Optional<String> getOrigin() {
        return Optional.ofNullable(this.origin);
    }

    @Override
    @JsonProperty(value="type")
    public Optional<MemberType> getType() {
        return Optional.ofNullable(this.type);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AddMemberResponse && this.equalTo((AddMemberResponse)another);
    }

    private boolean equalTo(AddMemberResponse another) {
        return this.memberId.equals(another.memberId) && Objects.equals(this.origin, another.origin) && Objects.equals((Object)this.type, (Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.memberId.hashCode();
        h += (h << 5) + Objects.hashCode(this.origin);
        h += (h << 5) + Objects.hashCode((Object)this.type);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AddMemberResponse{");
        builder.append("memberId=").append(this.memberId);
        if (this.origin != null) {
            builder.append(", ");
            builder.append("origin=").append(this.origin);
        }
        if (this.type != null) {
            builder.append(", ");
            builder.append("type=").append((Object)this.type);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static AddMemberResponse fromJson(Json json) {
        Builder builder = AddMemberResponse.builder();
        if (json.memberId != null) {
            builder.memberId(json.memberId);
        }
        if (json.origin != null) {
            builder.origin(json.origin);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MEMBER_ID = 1L;
        private long initBits = 1L;
        private String memberId;
        private String origin;
        private MemberType type;

        private Builder() {
        }

        public final Builder from(AbstractMember instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AddMemberResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_AddMemberResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof AbstractMember) {
                Optional<String> originOptional;
                AbstractMember instance = (AbstractMember)object;
                Optional<MemberType> typeOptional = instance.getType();
                if (typeOptional.isPresent()) {
                    this.type(typeOptional);
                }
                if ((originOptional = instance.getOrigin()).isPresent()) {
                    this.origin(originOptional);
                }
                this.memberId(instance.getMemberId());
            }
        }

        @JsonProperty(value="value")
        public final Builder memberId(String memberId) {
            this.memberId = Objects.requireNonNull(memberId, "memberId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder origin(String origin) {
            this.origin = Objects.requireNonNull(origin, "origin");
            return this;
        }

        @JsonProperty(value="origin")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public final Builder origin(Optional<String> origin) {
            this.origin = origin.orElse(null);
            return this;
        }

        public final Builder type(MemberType type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(Optional<? extends MemberType> type) {
            this.type = type.orElse(null);
            return this;
        }

        public AddMemberResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AddMemberResponse(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("memberId");
            }
            return "Cannot build AddMemberResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _AddMemberResponse {
        String memberId;
        Optional<String> origin = Optional.empty();
        Optional<MemberType> type = Optional.empty();

        Json() {
        }

        @JsonProperty(value="value")
        public void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        @JsonProperty(value="origin")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setOrigin(Optional<String> origin) {
            this.origin = origin;
        }

        @JsonProperty(value="type")
        public void setType(Optional<MemberType> type) {
            this.type = type;
        }

        @Override
        public String getMemberId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getOrigin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<MemberType> getType() {
            throw new UnsupportedOperationException();
        }
    }
}

