package org.cloudfoundry.client.v2.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Get the env for an App operation.
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_ApplicationEnvironmentRequest", generator = "Immutables")
public final class ApplicationEnvironmentRequest
    extends org.cloudfoundry.client.v2.applications._ApplicationEnvironmentRequest {
  private final String applicationId;

  private ApplicationEnvironmentRequest(ApplicationEnvironmentRequest.Builder builder) {
    this.applicationId = builder.applicationId;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * This instance is equal to all instances of {@code ApplicationEnvironmentRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplicationEnvironmentRequest
        && equalTo((ApplicationEnvironmentRequest) another);
  }

  private boolean equalTo(ApplicationEnvironmentRequest another) {
    return applicationId.equals(another.applicationId);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ApplicationEnvironmentRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplicationEnvironmentRequest{"
        + "applicationId=" + applicationId
        + "}";
  }

  /**
   * Creates a builder for {@link ApplicationEnvironmentRequest ApplicationEnvironmentRequest}.
   * @return A new ApplicationEnvironmentRequest builder
   */
  public static ApplicationEnvironmentRequest.Builder builder() {
    return new ApplicationEnvironmentRequest.Builder();
  }

  /**
   * Builds instances of type {@link ApplicationEnvironmentRequest ApplicationEnvironmentRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String applicationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplicationEnvironmentRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationEnvironmentRequest instance) {
      return from((_ApplicationEnvironmentRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ApplicationEnvironmentRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ApplicationEnvironmentRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEnvironmentRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Builds a new {@link ApplicationEnvironmentRequest ApplicationEnvironmentRequest}.
     * @return An immutable instance of ApplicationEnvironmentRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplicationEnvironmentRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ApplicationEnvironmentRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      return "Cannot build ApplicationEnvironmentRequest, some of required attributes are not set " + attributes;
    }
  }
}
