package org.cloudfoundry.client.v2.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;

/**
 * The request payload for the List all Service Bindings for the App operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_ListApplicationServiceBindingsRequest", generator = "Immutables")
public final class ListApplicationServiceBindingsRequest
    extends org.cloudfoundry.client.v2.applications._ListApplicationServiceBindingsRequest {
  private final String applicationId;
  private final @Nullable List<String> serviceInstanceIds;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListApplicationServiceBindingsRequest(ListApplicationServiceBindingsRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.serviceInstanceIds = builder.serviceInstanceIds == null ? null : createUnmodifiableList(true, builder.serviceInstanceIds);
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The ids of the service instances
   */
  @Override
  public @Nullable List<String> getServiceInstanceIds() {
    return serviceInstanceIds;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListApplicationServiceBindingsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListApplicationServiceBindingsRequest
        && equalTo((ListApplicationServiceBindingsRequest) another);
  }

  private boolean equalTo(ListApplicationServiceBindingsRequest another) {
    return applicationId.equals(another.applicationId)
        && Objects.equals(serviceInstanceIds, another.serviceInstanceIds)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code serviceInstanceIds}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationId.hashCode();
    h += (h << 5) + Objects.hashCode(serviceInstanceIds);
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListApplicationServiceBindingsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListApplicationServiceBindingsRequest{"
        + "applicationId=" + applicationId
        + ", serviceInstanceIds=" + serviceInstanceIds
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListApplicationServiceBindingsRequest ListApplicationServiceBindingsRequest}.
   * @return A new ListApplicationServiceBindingsRequest builder
   */
  public static ListApplicationServiceBindingsRequest.Builder builder() {
    return new ListApplicationServiceBindingsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListApplicationServiceBindingsRequest ListApplicationServiceBindingsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String applicationId;
    private List<String> serviceInstanceIds = null;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListApplicationServiceBindingsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListApplicationServiceBindingsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListApplicationServiceBindingsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListApplicationServiceBindingsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.applications._ListApplicationServiceBindingsRequest) {
        org.cloudfoundry.client.v2.applications._ListApplicationServiceBindingsRequest instance = (org.cloudfoundry.client.v2.applications._ListApplicationServiceBindingsRequest) object;
        applicationId(instance.getApplicationId());
        List<String> serviceInstanceIdsValue = instance.getServiceInstanceIds();
        if (serviceInstanceIdsValue != null) {
          addAllServiceInstanceIds(serviceInstanceIdsValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListApplicationServiceBindingsRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Adds one element to {@link ListApplicationServiceBindingsRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param element A serviceInstanceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceId(String element) {
      if (this.serviceInstanceIds == null) {
        this.serviceInstanceIds = new ArrayList<String>();
      }
      this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListApplicationServiceBindingsRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param elements An array of serviceInstanceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceIds(String... elements) {
      if (this.serviceInstanceIds == null) {
        this.serviceInstanceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListApplicationServiceBindingsRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param elements An iterable of serviceInstanceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.serviceInstanceIds = null;
        return this;
      }
      this.serviceInstanceIds = new ArrayList<String>();
      return addAllServiceInstanceIds(elements);
    }

    /**
     * Adds elements to {@link ListApplicationServiceBindingsRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param elements An iterable of serviceInstanceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceInstanceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "serviceInstanceIds element");
      if (this.serviceInstanceIds == null) {
        this.serviceInstanceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationServiceBindingsRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationServiceBindingsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationServiceBindingsRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListApplicationServiceBindingsRequest ListApplicationServiceBindingsRequest}.
     * @return An immutable instance of ListApplicationServiceBindingsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListApplicationServiceBindingsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListApplicationServiceBindingsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      return "Cannot build ListApplicationServiceBindingsRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
