package org.cloudfoundry.client.v2.featureflags;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Get SetUserRoles feature flag operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_GetFeatureFlagRequest", generator = "Immutables")
public final class GetFeatureFlagRequest
    extends org.cloudfoundry.client.v2.featureflags._GetFeatureFlagRequest {
  private final String name;

  private GetFeatureFlagRequest(GetFeatureFlagRequest.Builder builder) {
    this.name = builder.name;
  }

  /**
   * The name of the feature flag
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code GetFeatureFlagRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetFeatureFlagRequest
        && equalTo((GetFeatureFlagRequest) another);
  }

  private boolean equalTo(GetFeatureFlagRequest another) {
    return name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetFeatureFlagRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetFeatureFlagRequest{"
        + "name=" + name
        + "}";
  }


  private static GetFeatureFlagRequest validate(GetFeatureFlagRequest instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link GetFeatureFlagRequest GetFeatureFlagRequest}.
   * @return A new GetFeatureFlagRequest builder
   */
  public static GetFeatureFlagRequest.Builder builder() {
    return new GetFeatureFlagRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetFeatureFlagRequest GetFeatureFlagRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetFeatureFlagRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetFeatureFlagRequest instance) {
      return from((_GetFeatureFlagRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetFeatureFlagRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetFeatureFlagRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link GetFeatureFlagRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link GetFeatureFlagRequest GetFeatureFlagRequest}.
     * @return An immutable instance of GetFeatureFlagRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetFeatureFlagRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return GetFeatureFlagRequest.validate(new GetFeatureFlagRequest(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build GetFeatureFlagRequest, some of required attributes are not set " + attributes;
    }
  }
}
