package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Associate User with the Organization by Username operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_AssociateOrganizationUserByUsernameRequest", generator = "Immutables")
public final class AssociateOrganizationUserByUsernameRequest
    extends org.cloudfoundry.client.v2.organizations._AssociateOrganizationUserByUsernameRequest {
  private final String organizationId;
  private final @Nullable String origin;
  private final String username;

  private AssociateOrganizationUserByUsernameRequest(AssociateOrganizationUserByUsernameRequest.Builder builder) {
    this.organizationId = builder.organizationId;
    this.origin = builder.origin;
    this.username = builder.username;
  }

  /**
   * The organization id
   */
  @JsonProperty("organizationId")
  @JsonIgnore
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * The origin
   */
  @JsonProperty("origin")
  @Override
  public @Nullable String getOrigin() {
    return origin;
  }

  /**
   * The username
   */
  @JsonProperty("username")
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code AssociateOrganizationUserByUsernameRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssociateOrganizationUserByUsernameRequest
        && equalTo((AssociateOrganizationUserByUsernameRequest) another);
  }

  private boolean equalTo(AssociateOrganizationUserByUsernameRequest another) {
    return organizationId.equals(another.organizationId)
        && Objects.equals(origin, another.origin)
        && username.equals(another.username);
  }

  /**
   * Computes a hash code from attributes: {@code organizationId}, {@code origin}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + organizationId.hashCode();
    h += (h << 5) + Objects.hashCode(origin);
    h += (h << 5) + username.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssociateOrganizationUserByUsernameRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssociateOrganizationUserByUsernameRequest{"
        + "organizationId=" + organizationId
        + ", origin=" + origin
        + ", username=" + username
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.organizations._AssociateOrganizationUserByUsernameRequest {
    String organizationId;
    String origin;
    String username;
    @JsonProperty("organizationId")
    @JsonIgnore
    public void setOrganizationId(String organizationId) {
      this.organizationId = organizationId;
    }
    @JsonProperty("origin")
    public void setOrigin(@Nullable String origin) {
      this.origin = origin;
    }
    @JsonProperty("username")
    public void setUsername(String username) {
      this.username = username;
    }
    @Override
    public String getOrganizationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrigin() { throw new UnsupportedOperationException(); }
    @Override
    public String getUsername() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static AssociateOrganizationUserByUsernameRequest fromJson(Json json) {
    AssociateOrganizationUserByUsernameRequest.Builder builder = AssociateOrganizationUserByUsernameRequest.builder();
    if (json.organizationId != null) {
      builder.organizationId(json.organizationId);
    }
    if (json.origin != null) {
      builder.origin(json.origin);
    }
    if (json.username != null) {
      builder.username(json.username);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link AssociateOrganizationUserByUsernameRequest AssociateOrganizationUserByUsernameRequest}.
   * @return A new AssociateOrganizationUserByUsernameRequest builder
   */
  public static AssociateOrganizationUserByUsernameRequest.Builder builder() {
    return new AssociateOrganizationUserByUsernameRequest.Builder();
  }

  /**
   * Builds instances of type {@link AssociateOrganizationUserByUsernameRequest AssociateOrganizationUserByUsernameRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private static final long INIT_BIT_USERNAME = 0x2L;
    private long initBits = 0x3L;

    private String organizationId;
    private String origin;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssociateOrganizationUserByUsernameRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssociateOrganizationUserByUsernameRequest instance) {
      return from((_AssociateOrganizationUserByUsernameRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AssociateOrganizationUserByUsernameRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssociateOrganizationUserByUsernameRequest instance) {
      Objects.requireNonNull(instance, "instance");
      organizationId(instance.getOrganizationId());
      String originValue = instance.getOrigin();
      if (originValue != null) {
        origin(originValue);
      }
      username(instance.getUsername());
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateOrganizationUserByUsernameRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateOrganizationUserByUsernameRequest#getOrigin() origin} attribute.
     * @param origin The value for origin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder origin(@Nullable String origin) {
      this.origin = origin;
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateOrganizationUserByUsernameRequest#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Builds a new {@link AssociateOrganizationUserByUsernameRequest AssociateOrganizationUserByUsernameRequest}.
     * @return An immutable instance of AssociateOrganizationUserByUsernameRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssociateOrganizationUserByUsernameRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AssociateOrganizationUserByUsernameRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      return "Cannot build AssociateOrganizationUserByUsernameRequest, some of required attributes are not set " + attributes;
    }
  }
}
