package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The response payload for the Retrieving the organizations instance usage operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_GetOrganizationInstanceUsageResponse", generator = "Immutables")
public final class GetOrganizationInstanceUsageResponse
    extends org.cloudfoundry.client.v2.organizations._GetOrganizationInstanceUsageResponse {
  private final @Nullable Integer instanceUsage;

  private GetOrganizationInstanceUsageResponse(GetOrganizationInstanceUsageResponse.Builder builder) {
    this.instanceUsage = builder.instanceUsage;
  }

  /**
   * The instance usage
   */
  @JsonProperty("instance_usage")
  @Override
  public @Nullable Integer getInstanceUsage() {
    return instanceUsage;
  }

  /**
   * This instance is equal to all instances of {@code GetOrganizationInstanceUsageResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetOrganizationInstanceUsageResponse
        && equalTo((GetOrganizationInstanceUsageResponse) another);
  }

  private boolean equalTo(GetOrganizationInstanceUsageResponse another) {
    return Objects.equals(instanceUsage, another.instanceUsage);
  }

  /**
   * Computes a hash code from attributes: {@code instanceUsage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(instanceUsage);
    return h;
  }

  /**
   * Prints the immutable value {@code GetOrganizationInstanceUsageResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetOrganizationInstanceUsageResponse{"
        + "instanceUsage=" + instanceUsage
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.organizations._GetOrganizationInstanceUsageResponse {
    Integer instanceUsage;
    @JsonProperty("instance_usage")
    public void setInstanceUsage(@Nullable Integer instanceUsage) {
      this.instanceUsage = instanceUsage;
    }
    @Override
    public Integer getInstanceUsage() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetOrganizationInstanceUsageResponse fromJson(Json json) {
    GetOrganizationInstanceUsageResponse.Builder builder = GetOrganizationInstanceUsageResponse.builder();
    if (json.instanceUsage != null) {
      builder.instanceUsage(json.instanceUsage);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetOrganizationInstanceUsageResponse GetOrganizationInstanceUsageResponse}.
   * @return A new GetOrganizationInstanceUsageResponse builder
   */
  public static GetOrganizationInstanceUsageResponse.Builder builder() {
    return new GetOrganizationInstanceUsageResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetOrganizationInstanceUsageResponse GetOrganizationInstanceUsageResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Integer instanceUsage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetOrganizationInstanceUsageResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetOrganizationInstanceUsageResponse instance) {
      return from((_GetOrganizationInstanceUsageResponse) instance);
    }

    /**
     * Copy abstract value type {@code _GetOrganizationInstanceUsageResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetOrganizationInstanceUsageResponse instance) {
      Objects.requireNonNull(instance, "instance");
      Integer instanceUsageValue = instance.getInstanceUsage();
      if (instanceUsageValue != null) {
        instanceUsage(instanceUsageValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetOrganizationInstanceUsageResponse#getInstanceUsage() instanceUsage} attribute.
     * @param instanceUsage The value for instanceUsage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("instance_usage")
    public final Builder instanceUsage(@Nullable Integer instanceUsage) {
      this.instanceUsage = instanceUsage;
      return this;
    }

    /**
     * Builds a new {@link GetOrganizationInstanceUsageResponse GetOrganizationInstanceUsageResponse}.
     * @return An immutable instance of GetOrganizationInstanceUsageResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetOrganizationInstanceUsageResponse build() {
      return new GetOrganizationInstanceUsageResponse(this);
    }
  }
}
