package org.cloudfoundry.client.v2.routemappings;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload object for the Get a Route Mapping operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_GetRouteMappingRequest", generator = "Immutables")
public final class GetRouteMappingRequest
    extends org.cloudfoundry.client.v2.routemappings._GetRouteMappingRequest {
  private final String routeMappingId;

  private GetRouteMappingRequest(GetRouteMappingRequest.Builder builder) {
    this.routeMappingId = builder.routeMappingId;
  }

  /**
   * The route mapping id
   */
  @Override
  public String getRouteMappingId() {
    return routeMappingId;
  }

  /**
   * This instance is equal to all instances of {@code GetRouteMappingRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetRouteMappingRequest
        && equalTo((GetRouteMappingRequest) another);
  }

  private boolean equalTo(GetRouteMappingRequest another) {
    return routeMappingId.equals(another.routeMappingId);
  }

  /**
   * Computes a hash code from attributes: {@code routeMappingId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + routeMappingId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetRouteMappingRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetRouteMappingRequest{"
        + "routeMappingId=" + routeMappingId
        + "}";
  }

  /**
   * Creates a builder for {@link GetRouteMappingRequest GetRouteMappingRequest}.
   * @return A new GetRouteMappingRequest builder
   */
  public static GetRouteMappingRequest.Builder builder() {
    return new GetRouteMappingRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetRouteMappingRequest GetRouteMappingRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ROUTE_MAPPING_ID = 0x1L;
    private long initBits = 0x1L;

    private String routeMappingId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetRouteMappingRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetRouteMappingRequest instance) {
      return from((_GetRouteMappingRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetRouteMappingRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetRouteMappingRequest instance) {
      Objects.requireNonNull(instance, "instance");
      routeMappingId(instance.getRouteMappingId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetRouteMappingRequest#getRouteMappingId() routeMappingId} attribute.
     * @param routeMappingId The value for routeMappingId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeMappingId(String routeMappingId) {
      this.routeMappingId = Objects.requireNonNull(routeMappingId, "routeMappingId");
      initBits &= ~INIT_BIT_ROUTE_MAPPING_ID;
      return this;
    }

    /**
     * Builds a new {@link GetRouteMappingRequest GetRouteMappingRequest}.
     * @return An immutable instance of GetRouteMappingRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetRouteMappingRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetRouteMappingRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ROUTE_MAPPING_ID) != 0) attributes.add("routeMappingId");
      return "Cannot build GetRouteMappingRequest, some of required attributes are not set " + attributes;
    }
  }
}
