package org.cloudfoundry.client.v2.routes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Remove Application from the Route operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_RemoveRouteApplicationRequest", generator = "Immutables")
public final class RemoveRouteApplicationRequest
    extends org.cloudfoundry.client.v2.routes._RemoveRouteApplicationRequest {
  private final String applicationId;
  private final String routeId;

  private RemoveRouteApplicationRequest(RemoveRouteApplicationRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.routeId = builder.routeId;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The route id
   */
  @Override
  public String getRouteId() {
    return routeId;
  }

  /**
   * This instance is equal to all instances of {@code RemoveRouteApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveRouteApplicationRequest
        && equalTo((RemoveRouteApplicationRequest) another);
  }

  private boolean equalTo(RemoveRouteApplicationRequest another) {
    return applicationId.equals(another.applicationId)
        && routeId.equals(another.routeId);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code routeId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationId.hashCode();
    h += (h << 5) + routeId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveRouteApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveRouteApplicationRequest{"
        + "applicationId=" + applicationId
        + ", routeId=" + routeId
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveRouteApplicationRequest RemoveRouteApplicationRequest}.
   * @return A new RemoveRouteApplicationRequest builder
   */
  public static RemoveRouteApplicationRequest.Builder builder() {
    return new RemoveRouteApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveRouteApplicationRequest RemoveRouteApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private static final long INIT_BIT_ROUTE_ID = 0x2L;
    private long initBits = 0x3L;

    private String applicationId;
    private String routeId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveRouteApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveRouteApplicationRequest instance) {
      return from((_RemoveRouteApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveRouteApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveRouteApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      routeId(instance.getRouteId());
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveRouteApplicationRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveRouteApplicationRequest#getRouteId() routeId} attribute.
     * @param routeId The value for routeId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeId(String routeId) {
      this.routeId = Objects.requireNonNull(routeId, "routeId");
      initBits &= ~INIT_BIT_ROUTE_ID;
      return this;
    }

    /**
     * Builds a new {@link RemoveRouteApplicationRequest RemoveRouteApplicationRequest}.
     * @return An immutable instance of RemoveRouteApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveRouteApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveRouteApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      if ((initBits & INIT_BIT_ROUTE_ID) != 0) attributes.add("routeId");
      return "Cannot build RemoveRouteApplicationRequest, some of required attributes are not set " + attributes;
    }
  }
}
