package org.cloudfoundry.client.v2.securitygroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The entity response payload for the Security Group resource
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_SecurityGroupEntity", generator = "Immutables")
public final class SecurityGroupEntity extends org.cloudfoundry.client.v2.securitygroups._SecurityGroupEntity {
  private final @Nullable String name;
  private final @Nullable List<RuleEntity> rules;
  private final @Nullable Boolean runningDefault;
  private final @Nullable String spacesUrl;
  private final @Nullable Boolean stagingDefault;
  private final @Nullable String stagingSpacesUrl;

  private SecurityGroupEntity(SecurityGroupEntity.Builder builder) {
    this.name = builder.name;
    this.rules = builder.rules == null ? null : createUnmodifiableList(true, builder.rules);
    this.runningDefault = builder.runningDefault;
    this.spacesUrl = builder.spacesUrl;
    this.stagingDefault = builder.stagingDefault;
    this.stagingSpacesUrl = builder.stagingSpacesUrl;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The rules
   */
  @JsonProperty("rules")
  @Override
  public @Nullable List<RuleEntity> getRules() {
    return rules;
  }

  /**
   * The running default
   */
  @JsonProperty("running_default")
  @Override
  public @Nullable Boolean getRunningDefault() {
    return runningDefault;
  }

  /**
   * The spaces url
   */
  @JsonProperty("spaces_url")
  @Override
  public @Nullable String getSpacesUrl() {
    return spacesUrl;
  }

  /**
   * The staging default
   */
  @JsonProperty("staging_default")
  @Override
  public @Nullable Boolean getStagingDefault() {
    return stagingDefault;
  }

  /**
   * The staging spaces url
   */
  @JsonProperty("staging_spaces_url")
  @Override
  public @Nullable String getStagingSpacesUrl() {
    return stagingSpacesUrl;
  }

  /**
   * This instance is equal to all instances of {@code SecurityGroupEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SecurityGroupEntity
        && equalTo((SecurityGroupEntity) another);
  }

  private boolean equalTo(SecurityGroupEntity another) {
    return Objects.equals(name, another.name)
        && Objects.equals(rules, another.rules)
        && Objects.equals(runningDefault, another.runningDefault)
        && Objects.equals(spacesUrl, another.spacesUrl)
        && Objects.equals(stagingDefault, another.stagingDefault)
        && Objects.equals(stagingSpacesUrl, another.stagingSpacesUrl);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code rules}, {@code runningDefault}, {@code spacesUrl}, {@code stagingDefault}, {@code stagingSpacesUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(rules);
    h += (h << 5) + Objects.hashCode(runningDefault);
    h += (h << 5) + Objects.hashCode(spacesUrl);
    h += (h << 5) + Objects.hashCode(stagingDefault);
    h += (h << 5) + Objects.hashCode(stagingSpacesUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code SecurityGroupEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SecurityGroupEntity{"
        + "name=" + name
        + ", rules=" + rules
        + ", runningDefault=" + runningDefault
        + ", spacesUrl=" + spacesUrl
        + ", stagingDefault=" + stagingDefault
        + ", stagingSpacesUrl=" + stagingSpacesUrl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.securitygroups._SecurityGroupEntity {
    String name;
    List<RuleEntity> rules = null;
    Boolean runningDefault;
    String spacesUrl;
    Boolean stagingDefault;
    String stagingSpacesUrl;
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("rules")
    public void setRules(@Nullable List<RuleEntity> rules) {
      this.rules = rules;
    }
    @JsonProperty("running_default")
    public void setRunningDefault(@Nullable Boolean runningDefault) {
      this.runningDefault = runningDefault;
    }
    @JsonProperty("spaces_url")
    public void setSpacesUrl(@Nullable String spacesUrl) {
      this.spacesUrl = spacesUrl;
    }
    @JsonProperty("staging_default")
    public void setStagingDefault(@Nullable Boolean stagingDefault) {
      this.stagingDefault = stagingDefault;
    }
    @JsonProperty("staging_spaces_url")
    public void setStagingSpacesUrl(@Nullable String stagingSpacesUrl) {
      this.stagingSpacesUrl = stagingSpacesUrl;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public List<RuleEntity> getRules() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getRunningDefault() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpacesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getStagingDefault() { throw new UnsupportedOperationException(); }
    @Override
    public String getStagingSpacesUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static SecurityGroupEntity fromJson(Json json) {
    SecurityGroupEntity.Builder builder = SecurityGroupEntity.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.rules != null) {
      builder.addAllRules(json.rules);
    }
    if (json.runningDefault != null) {
      builder.runningDefault(json.runningDefault);
    }
    if (json.spacesUrl != null) {
      builder.spacesUrl(json.spacesUrl);
    }
    if (json.stagingDefault != null) {
      builder.stagingDefault(json.stagingDefault);
    }
    if (json.stagingSpacesUrl != null) {
      builder.stagingSpacesUrl(json.stagingSpacesUrl);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link SecurityGroupEntity SecurityGroupEntity}.
   * @return A new SecurityGroupEntity builder
   */
  public static SecurityGroupEntity.Builder builder() {
    return new SecurityGroupEntity.Builder();
  }

  /**
   * Builds instances of type {@link SecurityGroupEntity SecurityGroupEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String name;
    private List<RuleEntity> rules = null;
    private Boolean runningDefault;
    private String spacesUrl;
    private Boolean stagingDefault;
    private String stagingSpacesUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SecurityGroupEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SecurityGroupEntity instance) {
      return from((_SecurityGroupEntity) instance);
    }

    /**
     * Copy abstract value type {@code _SecurityGroupEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SecurityGroupEntity instance) {
      Objects.requireNonNull(instance, "instance");
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      List<RuleEntity> rulesValue = instance.getRules();
      if (rulesValue != null) {
        addAllRules(rulesValue);
      }
      Boolean runningDefaultValue = instance.getRunningDefault();
      if (runningDefaultValue != null) {
        runningDefault(runningDefaultValue);
      }
      String spacesUrlValue = instance.getSpacesUrl();
      if (spacesUrlValue != null) {
        spacesUrl(spacesUrlValue);
      }
      Boolean stagingDefaultValue = instance.getStagingDefault();
      if (stagingDefaultValue != null) {
        stagingDefault(stagingDefaultValue);
      }
      String stagingSpacesUrlValue = instance.getStagingSpacesUrl();
      if (stagingSpacesUrlValue != null) {
        stagingSpacesUrl(stagingSpacesUrlValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SecurityGroupEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Adds one element to {@link SecurityGroupEntity#getRules() rules} list.
     * @param element A rules element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rule(RuleEntity element) {
      if (this.rules == null) {
        this.rules = new ArrayList<RuleEntity>();
      }
      this.rules.add(Objects.requireNonNull(element, "rules element"));
      return this;
    }

    /**
     * Adds elements to {@link SecurityGroupEntity#getRules() rules} list.
     * @param elements An array of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rules(RuleEntity... elements) {
      if (this.rules == null) {
        this.rules = new ArrayList<RuleEntity>();
      }
      for (RuleEntity element : elements) {
        this.rules.add(Objects.requireNonNull(element, "rules element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SecurityGroupEntity#getRules() rules} list.
     * @param elements An iterable of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rules")
    public final Builder rules(@Nullable Iterable<? extends RuleEntity> elements) {
      if (elements == null) {
        this.rules = null;
        return this;
      }
      this.rules = new ArrayList<RuleEntity>();
      return addAllRules(elements);
    }

    /**
     * Adds elements to {@link SecurityGroupEntity#getRules() rules} list.
     * @param elements An iterable of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRules(Iterable<? extends RuleEntity> elements) {
      Objects.requireNonNull(elements, "rules element");
      if (this.rules == null) {
        this.rules = new ArrayList<RuleEntity>();
      }
      for (RuleEntity element : elements) {
        this.rules.add(Objects.requireNonNull(element, "rules element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SecurityGroupEntity#getRunningDefault() runningDefault} attribute.
     * @param runningDefault The value for runningDefault (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("running_default")
    public final Builder runningDefault(@Nullable Boolean runningDefault) {
      this.runningDefault = runningDefault;
      return this;
    }

    /**
     * Initializes the value for the {@link SecurityGroupEntity#getSpacesUrl() spacesUrl} attribute.
     * @param spacesUrl The value for spacesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("spaces_url")
    public final Builder spacesUrl(@Nullable String spacesUrl) {
      this.spacesUrl = spacesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link SecurityGroupEntity#getStagingDefault() stagingDefault} attribute.
     * @param stagingDefault The value for stagingDefault (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("staging_default")
    public final Builder stagingDefault(@Nullable Boolean stagingDefault) {
      this.stagingDefault = stagingDefault;
      return this;
    }

    /**
     * Initializes the value for the {@link SecurityGroupEntity#getStagingSpacesUrl() stagingSpacesUrl} attribute.
     * @param stagingSpacesUrl The value for stagingSpacesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("staging_spaces_url")
    public final Builder stagingSpacesUrl(@Nullable String stagingSpacesUrl) {
      this.stagingSpacesUrl = stagingSpacesUrl;
      return this;
    }

    /**
     * Builds a new {@link SecurityGroupEntity SecurityGroupEntity}.
     * @return An immutable instance of SecurityGroupEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SecurityGroupEntity build() {
      return new SecurityGroupEntity(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
