package org.cloudfoundry.client.v2.servicebindings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The last operation payload for Service Bindings
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_LastOperation", generator = "Immutables")
public final class LastOperation extends org.cloudfoundry.client.v2.servicebindings._LastOperation {
  private final @Nullable String createdAt;
  private final @Nullable String description;
  private final @Nullable String state;
  private final @Nullable String type;
  private final @Nullable String updatedAt;

  private LastOperation(LastOperation.Builder builder) {
    this.createdAt = builder.createdAt;
    this.description = builder.description;
    this.state = builder.state;
    this.type = builder.type;
    this.updatedAt = builder.updatedAt;
  }

  /**
   * When the entity was created
   */
  @JsonProperty("created_at")
  @Override
  public @Nullable String getCreatedAt() {
    return createdAt;
  }

  /**
   * The description
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The state
   */
  @JsonProperty("state")
  @Override
  public @Nullable String getState() {
    return state;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * When the entity was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * This instance is equal to all instances of {@code LastOperation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof LastOperation
        && equalTo((LastOperation) another);
  }

  private boolean equalTo(LastOperation another) {
    return Objects.equals(createdAt, another.createdAt)
        && Objects.equals(description, another.description)
        && Objects.equals(state, another.state)
        && Objects.equals(type, another.type)
        && Objects.equals(updatedAt, another.updatedAt);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code description}, {@code state}, {@code type}, {@code updatedAt}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(updatedAt);
    return h;
  }

  /**
   * Prints the immutable value {@code LastOperation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "LastOperation{"
        + "createdAt=" + createdAt
        + ", description=" + description
        + ", state=" + state
        + ", type=" + type
        + ", updatedAt=" + updatedAt
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.servicebindings._LastOperation {
    String createdAt;
    String description;
    String state;
    String type;
    String updatedAt;
    @JsonProperty("created_at")
    public void setCreatedAt(@Nullable String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("state")
    public void setState(@Nullable String state) {
      this.state = state;
    }
    @JsonProperty("type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getState() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static LastOperation fromJson(Json json) {
    LastOperation.Builder builder = LastOperation.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link LastOperation LastOperation}.
   * @return A new LastOperation builder
   */
  public static LastOperation.Builder builder() {
    return new LastOperation.Builder();
  }

  /**
   * Builds instances of type {@link LastOperation LastOperation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String createdAt;
    private String description;
    private String state;
    private String type;
    private String updatedAt;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LastOperation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(LastOperation instance) {
      return from((_LastOperation) instance);
    }

    /**
     * Copy abstract value type {@code _LastOperation} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_LastOperation instance) {
      Objects.requireNonNull(instance, "instance");
      String createdAtValue = instance.getCreatedAt();
      if (createdAtValue != null) {
        createdAt(createdAtValue);
      }
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      String stateValue = instance.getState();
      if (stateValue != null) {
        state(stateValue);
      }
      String typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      String updatedAtValue = instance.getUpdatedAt();
      if (updatedAtValue != null) {
        updatedAt(updatedAtValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link LastOperation#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(@Nullable String createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link LastOperation#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link LastOperation#getState() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("state")
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the value for the {@link LastOperation#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link LastOperation#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Builds a new {@link LastOperation LastOperation}.
     * @return An immutable instance of LastOperation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public LastOperation build() {
      return new LastOperation(this);
    }
  }
}
