package org.cloudfoundry.client.v2.servicekeys;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _DeleteServiceKeyRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code DeleteServiceKeyRequest.builder()}.
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_DeleteServiceKeyRequest", generator = "Immutables")
public final class DeleteServiceKeyRequest
    extends org.cloudfoundry.client.v2.servicekeys._DeleteServiceKeyRequest {
  private final String serviceKeyId;

  private DeleteServiceKeyRequest(DeleteServiceKeyRequest.Builder builder) {
    this.serviceKeyId = builder.serviceKeyId;
  }

  /**
   * The service key id
   */
  @Override
  public String getServiceKeyId() {
    return serviceKeyId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteServiceKeyRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteServiceKeyRequest
        && equalTo((DeleteServiceKeyRequest) another);
  }

  private boolean equalTo(DeleteServiceKeyRequest another) {
    return serviceKeyId.equals(another.serviceKeyId);
  }

  /**
   * Computes a hash code from attributes: {@code serviceKeyId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + serviceKeyId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteServiceKeyRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteServiceKeyRequest{"
        + "serviceKeyId=" + serviceKeyId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteServiceKeyRequest DeleteServiceKeyRequest}.
   * @return A new DeleteServiceKeyRequest builder
   */
  public static DeleteServiceKeyRequest.Builder builder() {
    return new DeleteServiceKeyRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteServiceKeyRequest DeleteServiceKeyRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_KEY_ID = 0x1L;
    private long initBits = 0x1L;

    private String serviceKeyId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteServiceKeyRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteServiceKeyRequest instance) {
      return from((_DeleteServiceKeyRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteServiceKeyRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteServiceKeyRequest instance) {
      Objects.requireNonNull(instance, "instance");
      serviceKeyId(instance.getServiceKeyId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteServiceKeyRequest#getServiceKeyId() serviceKeyId} attribute.
     * @param serviceKeyId The value for serviceKeyId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceKeyId(String serviceKeyId) {
      this.serviceKeyId = Objects.requireNonNull(serviceKeyId, "serviceKeyId");
      initBits &= ~INIT_BIT_SERVICE_KEY_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteServiceKeyRequest DeleteServiceKeyRequest}.
     * @return An immutable instance of DeleteServiceKeyRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteServiceKeyRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteServiceKeyRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_KEY_ID) != 0) attributes.add("serviceKeyId");
      return "Cannot build DeleteServiceKeyRequest, some of required attributes are not set " + attributes;
    }
  }
}
