package org.cloudfoundry.client.v2.serviceplanvisibilities;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Update Service Plan Visibility
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_UpdateServicePlanVisibilityRequest", generator = "Immutables")
public final class UpdateServicePlanVisibilityRequest
    extends org.cloudfoundry.client.v2.serviceplanvisibilities._UpdateServicePlanVisibilityRequest {
  private final String organizationId;
  private final String servicePlanId;
  private final String servicePlanVisibilityId;

  private UpdateServicePlanVisibilityRequest(UpdateServicePlanVisibilityRequest.Builder builder) {
    this.organizationId = builder.organizationId;
    this.servicePlanId = builder.servicePlanId;
    this.servicePlanVisibilityId = builder.servicePlanVisibilityId;
  }

  /**
   * The organization id
   */
  @JsonProperty("organization_guid")
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * The service plan id
   */
  @JsonProperty("service_plan_guid")
  @Override
  public String getServicePlanId() {
    return servicePlanId;
  }

  /**
   * The service plan visibility id
   */
  @JsonProperty("servicePlanVisibilityId")
  @JsonIgnore
  @Override
  public String getServicePlanVisibilityId() {
    return servicePlanVisibilityId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateServicePlanVisibilityRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateServicePlanVisibilityRequest
        && equalTo((UpdateServicePlanVisibilityRequest) another);
  }

  private boolean equalTo(UpdateServicePlanVisibilityRequest another) {
    return organizationId.equals(another.organizationId)
        && servicePlanId.equals(another.servicePlanId)
        && servicePlanVisibilityId.equals(another.servicePlanVisibilityId);
  }

  /**
   * Computes a hash code from attributes: {@code organizationId}, {@code servicePlanId}, {@code servicePlanVisibilityId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + organizationId.hashCode();
    h += (h << 5) + servicePlanId.hashCode();
    h += (h << 5) + servicePlanVisibilityId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateServicePlanVisibilityRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateServicePlanVisibilityRequest{"
        + "organizationId=" + organizationId
        + ", servicePlanId=" + servicePlanId
        + ", servicePlanVisibilityId=" + servicePlanVisibilityId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.serviceplanvisibilities._UpdateServicePlanVisibilityRequest {
    String organizationId;
    String servicePlanId;
    String servicePlanVisibilityId;
    @JsonProperty("organization_guid")
    public void setOrganizationId(String organizationId) {
      this.organizationId = organizationId;
    }
    @JsonProperty("service_plan_guid")
    public void setServicePlanId(String servicePlanId) {
      this.servicePlanId = servicePlanId;
    }
    @JsonProperty("servicePlanVisibilityId")
    @JsonIgnore
    public void setServicePlanVisibilityId(String servicePlanVisibilityId) {
      this.servicePlanVisibilityId = servicePlanVisibilityId;
    }
    @Override
    public String getOrganizationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getServicePlanId() { throw new UnsupportedOperationException(); }
    @Override
    public String getServicePlanVisibilityId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateServicePlanVisibilityRequest fromJson(Json json) {
    UpdateServicePlanVisibilityRequest.Builder builder = UpdateServicePlanVisibilityRequest.builder();
    if (json.organizationId != null) {
      builder.organizationId(json.organizationId);
    }
    if (json.servicePlanId != null) {
      builder.servicePlanId(json.servicePlanId);
    }
    if (json.servicePlanVisibilityId != null) {
      builder.servicePlanVisibilityId(json.servicePlanVisibilityId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateServicePlanVisibilityRequest UpdateServicePlanVisibilityRequest}.
   * @return A new UpdateServicePlanVisibilityRequest builder
   */
  public static UpdateServicePlanVisibilityRequest.Builder builder() {
    return new UpdateServicePlanVisibilityRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateServicePlanVisibilityRequest UpdateServicePlanVisibilityRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private static final long INIT_BIT_SERVICE_PLAN_ID = 0x2L;
    private static final long INIT_BIT_SERVICE_PLAN_VISIBILITY_ID = 0x4L;
    private long initBits = 0x7L;

    private String organizationId;
    private String servicePlanId;
    private String servicePlanVisibilityId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateServicePlanVisibilityRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateServicePlanVisibilityRequest instance) {
      return from((_UpdateServicePlanVisibilityRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateServicePlanVisibilityRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateServicePlanVisibilityRequest instance) {
      Objects.requireNonNull(instance, "instance");
      organizationId(instance.getOrganizationId());
      servicePlanId(instance.getServicePlanId());
      servicePlanVisibilityId(instance.getServicePlanVisibilityId());
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServicePlanVisibilityRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServicePlanVisibilityRequest#getServicePlanId() servicePlanId} attribute.
     * @param servicePlanId The value for servicePlanId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanId(String servicePlanId) {
      this.servicePlanId = Objects.requireNonNull(servicePlanId, "servicePlanId");
      initBits &= ~INIT_BIT_SERVICE_PLAN_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServicePlanVisibilityRequest#getServicePlanVisibilityId() servicePlanVisibilityId} attribute.
     * @param servicePlanVisibilityId The value for servicePlanVisibilityId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanVisibilityId(String servicePlanVisibilityId) {
      this.servicePlanVisibilityId = Objects.requireNonNull(servicePlanVisibilityId, "servicePlanVisibilityId");
      initBits &= ~INIT_BIT_SERVICE_PLAN_VISIBILITY_ID;
      return this;
    }

    /**
     * Builds a new {@link UpdateServicePlanVisibilityRequest UpdateServicePlanVisibilityRequest}.
     * @return An immutable instance of UpdateServicePlanVisibilityRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateServicePlanVisibilityRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateServicePlanVisibilityRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      if ((initBits & INIT_BIT_SERVICE_PLAN_ID) != 0) attributes.add("servicePlanId");
      if ((initBits & INIT_BIT_SERVICE_PLAN_VISIBILITY_ID) != 0) attributes.add("servicePlanVisibilityId");
      return "Cannot build UpdateServicePlanVisibilityRequest, some of required attributes are not set " + attributes;
    }
  }
}
