package org.cloudfoundry.client.v2.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;

/**
 * The request payload for the List Services operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_ListServicesRequest", generator = "Immutables")
public final class ListServicesRequest extends org.cloudfoundry.client.v2.services._ListServicesRequest {
  private final @Nullable Boolean active;
  private final @Nullable List<String> labels;
  private final @Nullable List<String> providers;
  private final @Nullable List<String> serviceBrokerIds;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListServicesRequest(ListServicesRequest.Builder builder) {
    this.active = builder.active;
    this.labels = builder.labels == null ? null : createUnmodifiableList(true, builder.labels);
    this.providers = builder.providers == null ? null : createUnmodifiableList(true, builder.providers);
    this.serviceBrokerIds = builder.serviceBrokerIds == null ? null : createUnmodifiableList(true, builder.serviceBrokerIds);
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The active flag
   */
  @Override
  public @Nullable Boolean getActive() {
    return active;
  }

  /**
   * The labels
   */
  @Override
  public @Nullable List<String> getLabels() {
    return labels;
  }

  /**
   * The providers
   */
  @Override
  public @Nullable List<String> getProviders() {
    return providers;
  }

  /**
   * The service broker ids
   */
  @Override
  public @Nullable List<String> getServiceBrokerIds() {
    return serviceBrokerIds;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListServicesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListServicesRequest
        && equalTo((ListServicesRequest) another);
  }

  private boolean equalTo(ListServicesRequest another) {
    return Objects.equals(active, another.active)
        && Objects.equals(labels, another.labels)
        && Objects.equals(providers, another.providers)
        && Objects.equals(serviceBrokerIds, another.serviceBrokerIds)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code active}, {@code labels}, {@code providers}, {@code serviceBrokerIds}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(active);
    h += (h << 5) + Objects.hashCode(labels);
    h += (h << 5) + Objects.hashCode(providers);
    h += (h << 5) + Objects.hashCode(serviceBrokerIds);
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListServicesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListServicesRequest{"
        + "active=" + active
        + ", labels=" + labels
        + ", providers=" + providers
        + ", serviceBrokerIds=" + serviceBrokerIds
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListServicesRequest ListServicesRequest}.
   * @return A new ListServicesRequest builder
   */
  public static ListServicesRequest.Builder builder() {
    return new ListServicesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListServicesRequest ListServicesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Boolean active;
    private List<String> labels = null;
    private List<String> providers = null;
    private List<String> serviceBrokerIds = null;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListServicesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListServicesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListServicesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListServicesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v2.services._ListServicesRequest) {
        org.cloudfoundry.client.v2.services._ListServicesRequest instance = (org.cloudfoundry.client.v2.services._ListServicesRequest) object;
        Boolean activeValue = instance.getActive();
        if (activeValue != null) {
          active(activeValue);
        }
        List<String> serviceBrokerIdsValue = instance.getServiceBrokerIds();
        if (serviceBrokerIdsValue != null) {
          addAllServiceBrokerIds(serviceBrokerIdsValue);
        }
        List<String> providersValue = instance.getProviders();
        if (providersValue != null) {
          addAllProviders(providersValue);
        }
        List<String> labelsValue = instance.getLabels();
        if (labelsValue != null) {
          addAllLabels(labelsValue);
        }
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListServicesRequest#getActive() active} attribute.
     * @param active The value for active (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder active(@Nullable Boolean active) {
      this.active = active;
      return this;
    }

    /**
     * Adds one element to {@link ListServicesRequest#getLabels() labels} list.
     * @param element A labels element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder label(String element) {
      if (this.labels == null) {
        this.labels = new ArrayList<String>();
      }
      this.labels.add(Objects.requireNonNull(element, "labels element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicesRequest#getLabels() labels} list.
     * @param elements An array of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder labels(String... elements) {
      if (this.labels == null) {
        this.labels = new ArrayList<String>();
      }
      for (String element : elements) {
        this.labels.add(Objects.requireNonNull(element, "labels element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicesRequest#getLabels() labels} list.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder labels(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.labels = null;
        return this;
      }
      this.labels = new ArrayList<String>();
      return addAllLabels(elements);
    }

    /**
     * Adds elements to {@link ListServicesRequest#getLabels() labels} list.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllLabels(Iterable<String> elements) {
      Objects.requireNonNull(elements, "labels element");
      if (this.labels == null) {
        this.labels = new ArrayList<String>();
      }
      for (String element : elements) {
        this.labels.add(Objects.requireNonNull(element, "labels element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServicesRequest#getProviders() providers} list.
     * @param element A providers element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder provider(String element) {
      if (this.providers == null) {
        this.providers = new ArrayList<String>();
      }
      this.providers.add(Objects.requireNonNull(element, "providers element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicesRequest#getProviders() providers} list.
     * @param elements An array of providers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder providers(String... elements) {
      if (this.providers == null) {
        this.providers = new ArrayList<String>();
      }
      for (String element : elements) {
        this.providers.add(Objects.requireNonNull(element, "providers element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicesRequest#getProviders() providers} list.
     * @param elements An iterable of providers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder providers(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.providers = null;
        return this;
      }
      this.providers = new ArrayList<String>();
      return addAllProviders(elements);
    }

    /**
     * Adds elements to {@link ListServicesRequest#getProviders() providers} list.
     * @param elements An iterable of providers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllProviders(Iterable<String> elements) {
      Objects.requireNonNull(elements, "providers element");
      if (this.providers == null) {
        this.providers = new ArrayList<String>();
      }
      for (String element : elements) {
        this.providers.add(Objects.requireNonNull(element, "providers element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServicesRequest#getServiceBrokerIds() serviceBrokerIds} list.
     * @param element A serviceBrokerIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerId(String element) {
      if (this.serviceBrokerIds == null) {
        this.serviceBrokerIds = new ArrayList<String>();
      }
      this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicesRequest#getServiceBrokerIds() serviceBrokerIds} list.
     * @param elements An array of serviceBrokerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerIds(String... elements) {
      if (this.serviceBrokerIds == null) {
        this.serviceBrokerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicesRequest#getServiceBrokerIds() serviceBrokerIds} list.
     * @param elements An iterable of serviceBrokerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.serviceBrokerIds = null;
        return this;
      }
      this.serviceBrokerIds = new ArrayList<String>();
      return addAllServiceBrokerIds(elements);
    }

    /**
     * Adds elements to {@link ListServicesRequest#getServiceBrokerIds() serviceBrokerIds} list.
     * @param elements An iterable of serviceBrokerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceBrokerIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "serviceBrokerIds element");
      if (this.serviceBrokerIds == null) {
        this.serviceBrokerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListServicesRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServicesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServicesRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListServicesRequest ListServicesRequest}.
     * @return An immutable instance of ListServicesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListServicesRequest build() {
      return new ListServicesRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
