package org.cloudfoundry.client.v2.spacequotadefinitions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.Metadata;

/**
 * The response payload for the Create a Space Quota Definition operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_CreateSpaceQuotaDefinitionResponse", generator = "Immutables")
public final class CreateSpaceQuotaDefinitionResponse
    extends org.cloudfoundry.client.v2.spacequotadefinitions._CreateSpaceQuotaDefinitionResponse {
  private final @Nullable SpaceQuotaDefinitionEntity entity;
  private final @Nullable Metadata metadata;

  private CreateSpaceQuotaDefinitionResponse(CreateSpaceQuotaDefinitionResponse.Builder builder) {
    this.entity = builder.entity;
    this.metadata = builder.metadata;
  }

  /**
   * The resource's entity
   */
  @JsonProperty("entity")
  @Override
  public @Nullable SpaceQuotaDefinitionEntity getEntity() {
    return entity;
  }

  /**
   * The resource's metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * This instance is equal to all instances of {@code CreateSpaceQuotaDefinitionResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateSpaceQuotaDefinitionResponse
        && equalTo((CreateSpaceQuotaDefinitionResponse) another);
  }

  private boolean equalTo(CreateSpaceQuotaDefinitionResponse another) {
    return Objects.equals(entity, another.entity)
        && Objects.equals(metadata, another.metadata);
  }

  /**
   * Computes a hash code from attributes: {@code entity}, {@code metadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(entity);
    h += (h << 5) + Objects.hashCode(metadata);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateSpaceQuotaDefinitionResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateSpaceQuotaDefinitionResponse{"
        + "entity=" + entity
        + ", metadata=" + metadata
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.spacequotadefinitions._CreateSpaceQuotaDefinitionResponse {
    SpaceQuotaDefinitionEntity entity;
    Metadata metadata;
    @JsonProperty("entity")
    public void setEntity(@Nullable SpaceQuotaDefinitionEntity entity) {
      this.entity = entity;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @Override
    public SpaceQuotaDefinitionEntity getEntity() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateSpaceQuotaDefinitionResponse fromJson(Json json) {
    CreateSpaceQuotaDefinitionResponse.Builder builder = CreateSpaceQuotaDefinitionResponse.builder();
    if (json.entity != null) {
      builder.entity(json.entity);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateSpaceQuotaDefinitionResponse CreateSpaceQuotaDefinitionResponse}.
   * @return A new CreateSpaceQuotaDefinitionResponse builder
   */
  public static CreateSpaceQuotaDefinitionResponse.Builder builder() {
    return new CreateSpaceQuotaDefinitionResponse.Builder();
  }

  /**
   * Builds instances of type {@link CreateSpaceQuotaDefinitionResponse CreateSpaceQuotaDefinitionResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private SpaceQuotaDefinitionEntity entity;
    private Metadata metadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateSpaceQuotaDefinitionResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateSpaceQuotaDefinitionResponse instance) {
      return from((_CreateSpaceQuotaDefinitionResponse) instance);
    }

    /**
     * Copy abstract value type {@code _CreateSpaceQuotaDefinitionResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateSpaceQuotaDefinitionResponse instance) {
      Objects.requireNonNull(instance, "instance");
      SpaceQuotaDefinitionEntity entityValue = instance.getEntity();
      if (entityValue != null) {
        entity(entityValue);
      }
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSpaceQuotaDefinitionResponse#getEntity() entity} attribute.
     * @param entity The value for entity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("entity")
    public final Builder entity(@Nullable SpaceQuotaDefinitionEntity entity) {
      this.entity = entity;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSpaceQuotaDefinitionResponse#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Builds a new {@link CreateSpaceQuotaDefinitionResponse CreateSpaceQuotaDefinitionResponse}.
     * @return An immutable instance of CreateSpaceQuotaDefinitionResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateSpaceQuotaDefinitionResponse build() {
      return new CreateSpaceQuotaDefinitionResponse(this);
    }
  }
}
