package org.cloudfoundry.client.v2.spacequotadefinitions;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Retrieve a Particular Space Quota Definition operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_GetSpaceQuotaDefinitionRequest", generator = "Immutables")
public final class GetSpaceQuotaDefinitionRequest
    extends org.cloudfoundry.client.v2.spacequotadefinitions._GetSpaceQuotaDefinitionRequest {
  private final String spaceQuotaDefinitionId;

  private GetSpaceQuotaDefinitionRequest(GetSpaceQuotaDefinitionRequest.Builder builder) {
    this.spaceQuotaDefinitionId = builder.spaceQuotaDefinitionId;
  }

  /**
   * The space quota definition id
   */
  @Override
  public String getSpaceQuotaDefinitionId() {
    return spaceQuotaDefinitionId;
  }

  /**
   * This instance is equal to all instances of {@code GetSpaceQuotaDefinitionRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetSpaceQuotaDefinitionRequest
        && equalTo((GetSpaceQuotaDefinitionRequest) another);
  }

  private boolean equalTo(GetSpaceQuotaDefinitionRequest another) {
    return spaceQuotaDefinitionId.equals(another.spaceQuotaDefinitionId);
  }

  /**
   * Computes a hash code from attributes: {@code spaceQuotaDefinitionId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + spaceQuotaDefinitionId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetSpaceQuotaDefinitionRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetSpaceQuotaDefinitionRequest{"
        + "spaceQuotaDefinitionId=" + spaceQuotaDefinitionId
        + "}";
  }

  /**
   * Creates a builder for {@link GetSpaceQuotaDefinitionRequest GetSpaceQuotaDefinitionRequest}.
   * @return A new GetSpaceQuotaDefinitionRequest builder
   */
  public static GetSpaceQuotaDefinitionRequest.Builder builder() {
    return new GetSpaceQuotaDefinitionRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetSpaceQuotaDefinitionRequest GetSpaceQuotaDefinitionRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SPACE_QUOTA_DEFINITION_ID = 0x1L;
    private long initBits = 0x1L;

    private String spaceQuotaDefinitionId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetSpaceQuotaDefinitionRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetSpaceQuotaDefinitionRequest instance) {
      return from((_GetSpaceQuotaDefinitionRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetSpaceQuotaDefinitionRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetSpaceQuotaDefinitionRequest instance) {
      Objects.requireNonNull(instance, "instance");
      spaceQuotaDefinitionId(instance.getSpaceQuotaDefinitionId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetSpaceQuotaDefinitionRequest#getSpaceQuotaDefinitionId() spaceQuotaDefinitionId} attribute.
     * @param spaceQuotaDefinitionId The value for spaceQuotaDefinitionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceQuotaDefinitionId(String spaceQuotaDefinitionId) {
      this.spaceQuotaDefinitionId = Objects.requireNonNull(spaceQuotaDefinitionId, "spaceQuotaDefinitionId");
      initBits &= ~INIT_BIT_SPACE_QUOTA_DEFINITION_ID;
      return this;
    }

    /**
     * Builds a new {@link GetSpaceQuotaDefinitionRequest GetSpaceQuotaDefinitionRequest}.
     * @return An immutable instance of GetSpaceQuotaDefinitionRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetSpaceQuotaDefinitionRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetSpaceQuotaDefinitionRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SPACE_QUOTA_DEFINITION_ID) != 0) attributes.add("spaceQuotaDefinitionId");
      return "Cannot build GetSpaceQuotaDefinitionRequest, some of required attributes are not set " + attributes;
    }
  }
}
