package org.cloudfoundry.client.v2.spaces;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Associate Security Group with the Space operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_AssociateSpaceSecurityGroupRequest", generator = "Immutables")
public final class AssociateSpaceSecurityGroupRequest
    extends org.cloudfoundry.client.v2.spaces._AssociateSpaceSecurityGroupRequest {
  private final String securityGroupId;
  private final String spaceId;

  private AssociateSpaceSecurityGroupRequest(AssociateSpaceSecurityGroupRequest.Builder builder) {
    this.securityGroupId = builder.securityGroupId;
    this.spaceId = builder.spaceId;
  }

  /**
   * The security group id
   */
  @Override
  public String getSecurityGroupId() {
    return securityGroupId;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code AssociateSpaceSecurityGroupRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssociateSpaceSecurityGroupRequest
        && equalTo((AssociateSpaceSecurityGroupRequest) another);
  }

  private boolean equalTo(AssociateSpaceSecurityGroupRequest another) {
    return securityGroupId.equals(another.securityGroupId)
        && spaceId.equals(another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code securityGroupId}, {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + securityGroupId.hashCode();
    h += (h << 5) + spaceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssociateSpaceSecurityGroupRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssociateSpaceSecurityGroupRequest{"
        + "securityGroupId=" + securityGroupId
        + ", spaceId=" + spaceId
        + "}";
  }

  /**
   * Creates a builder for {@link AssociateSpaceSecurityGroupRequest AssociateSpaceSecurityGroupRequest}.
   * @return A new AssociateSpaceSecurityGroupRequest builder
   */
  public static AssociateSpaceSecurityGroupRequest.Builder builder() {
    return new AssociateSpaceSecurityGroupRequest.Builder();
  }

  /**
   * Builds instances of type {@link AssociateSpaceSecurityGroupRequest AssociateSpaceSecurityGroupRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SECURITY_GROUP_ID = 0x1L;
    private static final long INIT_BIT_SPACE_ID = 0x2L;
    private long initBits = 0x3L;

    private String securityGroupId;
    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssociateSpaceSecurityGroupRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssociateSpaceSecurityGroupRequest instance) {
      return from((_AssociateSpaceSecurityGroupRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AssociateSpaceSecurityGroupRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssociateSpaceSecurityGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      securityGroupId(instance.getSecurityGroupId());
      spaceId(instance.getSpaceId());
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateSpaceSecurityGroupRequest#getSecurityGroupId() securityGroupId} attribute.
     * @param securityGroupId The value for securityGroupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupId(String securityGroupId) {
      this.securityGroupId = Objects.requireNonNull(securityGroupId, "securityGroupId");
      initBits &= ~INIT_BIT_SECURITY_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateSpaceSecurityGroupRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Builds a new {@link AssociateSpaceSecurityGroupRequest AssociateSpaceSecurityGroupRequest}.
     * @return An immutable instance of AssociateSpaceSecurityGroupRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssociateSpaceSecurityGroupRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AssociateSpaceSecurityGroupRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SECURITY_GROUP_ID) != 0) attributes.add("securityGroupId");
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build AssociateSpaceSecurityGroupRequest, some of required attributes are not set " + attributes;
    }
  }
}
