package org.cloudfoundry.client.v2.spaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;

/**
 * The request payload for the List all Events for the Space operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_ListSpaceEventsRequest", generator = "Immutables")
public final class ListSpaceEventsRequest extends org.cloudfoundry.client.v2.spaces._ListSpaceEventsRequest {
  private final @Nullable List<String> actees;
  private final String spaceId;
  private final @Nullable List<String> timestamps;
  private final @Nullable List<String> types;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListSpaceEventsRequest(ListSpaceEventsRequest.Builder builder) {
    this.actees = builder.actees == null ? null : createUnmodifiableList(true, builder.actees);
    this.spaceId = builder.spaceId;
    this.timestamps = builder.timestamps == null ? null : createUnmodifiableList(true, builder.timestamps);
    this.types = builder.types == null ? null : createUnmodifiableList(true, builder.types);
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The actees
   */
  @Override
  public @Nullable List<String> getActees() {
    return actees;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * The timestamps
   */
  @Override
  public @Nullable List<String> getTimestamps() {
    return timestamps;
  }

  /**
   * The types
   */
  @Override
  public @Nullable List<String> getTypes() {
    return types;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListSpaceEventsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListSpaceEventsRequest
        && equalTo((ListSpaceEventsRequest) another);
  }

  private boolean equalTo(ListSpaceEventsRequest another) {
    return Objects.equals(actees, another.actees)
        && spaceId.equals(another.spaceId)
        && Objects.equals(timestamps, another.timestamps)
        && Objects.equals(types, another.types)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code actees}, {@code spaceId}, {@code timestamps}, {@code types}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(actees);
    h += (h << 5) + spaceId.hashCode();
    h += (h << 5) + Objects.hashCode(timestamps);
    h += (h << 5) + Objects.hashCode(types);
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListSpaceEventsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListSpaceEventsRequest{"
        + "actees=" + actees
        + ", spaceId=" + spaceId
        + ", timestamps=" + timestamps
        + ", types=" + types
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListSpaceEventsRequest ListSpaceEventsRequest}.
   * @return A new ListSpaceEventsRequest builder
   */
  public static ListSpaceEventsRequest.Builder builder() {
    return new ListSpaceEventsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListSpaceEventsRequest ListSpaceEventsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SPACE_ID = 0x1L;
    private long initBits = 0x1L;

    private List<String> actees = null;
    private String spaceId;
    private List<String> timestamps = null;
    private List<String> types = null;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListSpaceEventsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListSpaceEventsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListSpaceEventsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListSpaceEventsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.spaces._ListSpaceEventsRequest) {
        org.cloudfoundry.client.v2.spaces._ListSpaceEventsRequest instance = (org.cloudfoundry.client.v2.spaces._ListSpaceEventsRequest) object;
        spaceId(instance.getSpaceId());
        List<String> typesValue = instance.getTypes();
        if (typesValue != null) {
          addAllTypes(typesValue);
        }
        List<String> timestampsValue = instance.getTimestamps();
        if (timestampsValue != null) {
          addAllTimestamps(timestampsValue);
        }
        List<String> acteesValue = instance.getActees();
        if (acteesValue != null) {
          addAllActees(acteesValue);
        }
      }
    }

    /**
     * Adds one element to {@link ListSpaceEventsRequest#getActees() actees} list.
     * @param element A actees element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder actee(String element) {
      if (this.actees == null) {
        this.actees = new ArrayList<String>();
      }
      this.actees.add(Objects.requireNonNull(element, "actees element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSpaceEventsRequest#getActees() actees} list.
     * @param elements An array of actees elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder actees(String... elements) {
      if (this.actees == null) {
        this.actees = new ArrayList<String>();
      }
      for (String element : elements) {
        this.actees.add(Objects.requireNonNull(element, "actees element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSpaceEventsRequest#getActees() actees} list.
     * @param elements An iterable of actees elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder actees(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.actees = null;
        return this;
      }
      this.actees = new ArrayList<String>();
      return addAllActees(elements);
    }

    /**
     * Adds elements to {@link ListSpaceEventsRequest#getActees() actees} list.
     * @param elements An iterable of actees elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllActees(Iterable<String> elements) {
      Objects.requireNonNull(elements, "actees element");
      if (this.actees == null) {
        this.actees = new ArrayList<String>();
      }
      for (String element : elements) {
        this.actees.add(Objects.requireNonNull(element, "actees element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListSpaceEventsRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Adds one element to {@link ListSpaceEventsRequest#getTimestamps() timestamps} list.
     * @param element A timestamps element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timestamp(String element) {
      if (this.timestamps == null) {
        this.timestamps = new ArrayList<String>();
      }
      this.timestamps.add(Objects.requireNonNull(element, "timestamps element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSpaceEventsRequest#getTimestamps() timestamps} list.
     * @param elements An array of timestamps elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timestamps(String... elements) {
      if (this.timestamps == null) {
        this.timestamps = new ArrayList<String>();
      }
      for (String element : elements) {
        this.timestamps.add(Objects.requireNonNull(element, "timestamps element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSpaceEventsRequest#getTimestamps() timestamps} list.
     * @param elements An iterable of timestamps elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timestamps(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.timestamps = null;
        return this;
      }
      this.timestamps = new ArrayList<String>();
      return addAllTimestamps(elements);
    }

    /**
     * Adds elements to {@link ListSpaceEventsRequest#getTimestamps() timestamps} list.
     * @param elements An iterable of timestamps elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTimestamps(Iterable<String> elements) {
      Objects.requireNonNull(elements, "timestamps element");
      if (this.timestamps == null) {
        this.timestamps = new ArrayList<String>();
      }
      for (String element : elements) {
        this.timestamps.add(Objects.requireNonNull(element, "timestamps element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListSpaceEventsRequest#getTypes() types} list.
     * @param element A types element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(String element) {
      if (this.types == null) {
        this.types = new ArrayList<String>();
      }
      this.types.add(Objects.requireNonNull(element, "types element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSpaceEventsRequest#getTypes() types} list.
     * @param elements An array of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder types(String... elements) {
      if (this.types == null) {
        this.types = new ArrayList<String>();
      }
      for (String element : elements) {
        this.types.add(Objects.requireNonNull(element, "types element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSpaceEventsRequest#getTypes() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder types(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.types = null;
        return this;
      }
      this.types = new ArrayList<String>();
      return addAllTypes(elements);
    }

    /**
     * Adds elements to {@link ListSpaceEventsRequest#getTypes() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTypes(Iterable<String> elements) {
      Objects.requireNonNull(elements, "types element");
      if (this.types == null) {
        this.types = new ArrayList<String>();
      }
      for (String element : elements) {
        this.types.add(Objects.requireNonNull(element, "types element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListSpaceEventsRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListSpaceEventsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListSpaceEventsRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListSpaceEventsRequest ListSpaceEventsRequest}.
     * @return An immutable instance of ListSpaceEventsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListSpaceEventsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListSpaceEventsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build ListSpaceEventsRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
