package org.cloudfoundry.client.v2.userprovidedserviceinstances;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Associate Route User Provided Service Instance
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_RemoveUserProvidedServiceInstanceRouteRequest", generator = "Immutables")
public final class RemoveUserProvidedServiceInstanceRouteRequest
    extends org.cloudfoundry.client.v2.userprovidedserviceinstances._RemoveUserProvidedServiceInstanceRouteRequest {
  private final String routeId;
  private final String userProvidedServiceInstanceId;

  private RemoveUserProvidedServiceInstanceRouteRequest(RemoveUserProvidedServiceInstanceRouteRequest.Builder builder) {
    this.routeId = builder.routeId;
    this.userProvidedServiceInstanceId = builder.userProvidedServiceInstanceId;
  }

  /**
   * The route id
   */
  @Override
  public String getRouteId() {
    return routeId;
  }

  /**
   * The user provided service instance id
   */
  @Override
  public String getUserProvidedServiceInstanceId() {
    return userProvidedServiceInstanceId;
  }

  /**
   * This instance is equal to all instances of {@code RemoveUserProvidedServiceInstanceRouteRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveUserProvidedServiceInstanceRouteRequest
        && equalTo((RemoveUserProvidedServiceInstanceRouteRequest) another);
  }

  private boolean equalTo(RemoveUserProvidedServiceInstanceRouteRequest another) {
    return routeId.equals(another.routeId)
        && userProvidedServiceInstanceId.equals(another.userProvidedServiceInstanceId);
  }

  /**
   * Computes a hash code from attributes: {@code routeId}, {@code userProvidedServiceInstanceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + routeId.hashCode();
    h += (h << 5) + userProvidedServiceInstanceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveUserProvidedServiceInstanceRouteRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveUserProvidedServiceInstanceRouteRequest{"
        + "routeId=" + routeId
        + ", userProvidedServiceInstanceId=" + userProvidedServiceInstanceId
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveUserProvidedServiceInstanceRouteRequest RemoveUserProvidedServiceInstanceRouteRequest}.
   * @return A new RemoveUserProvidedServiceInstanceRouteRequest builder
   */
  public static RemoveUserProvidedServiceInstanceRouteRequest.Builder builder() {
    return new RemoveUserProvidedServiceInstanceRouteRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveUserProvidedServiceInstanceRouteRequest RemoveUserProvidedServiceInstanceRouteRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ROUTE_ID = 0x1L;
    private static final long INIT_BIT_USER_PROVIDED_SERVICE_INSTANCE_ID = 0x2L;
    private long initBits = 0x3L;

    private String routeId;
    private String userProvidedServiceInstanceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveUserProvidedServiceInstanceRouteRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveUserProvidedServiceInstanceRouteRequest instance) {
      return from((_RemoveUserProvidedServiceInstanceRouteRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveUserProvidedServiceInstanceRouteRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveUserProvidedServiceInstanceRouteRequest instance) {
      Objects.requireNonNull(instance, "instance");
      routeId(instance.getRouteId());
      userProvidedServiceInstanceId(instance.getUserProvidedServiceInstanceId());
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveUserProvidedServiceInstanceRouteRequest#getRouteId() routeId} attribute.
     * @param routeId The value for routeId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeId(String routeId) {
      this.routeId = Objects.requireNonNull(routeId, "routeId");
      initBits &= ~INIT_BIT_ROUTE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveUserProvidedServiceInstanceRouteRequest#getUserProvidedServiceInstanceId() userProvidedServiceInstanceId} attribute.
     * @param userProvidedServiceInstanceId The value for userProvidedServiceInstanceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userProvidedServiceInstanceId(String userProvidedServiceInstanceId) {
      this.userProvidedServiceInstanceId = Objects.requireNonNull(userProvidedServiceInstanceId, "userProvidedServiceInstanceId");
      initBits &= ~INIT_BIT_USER_PROVIDED_SERVICE_INSTANCE_ID;
      return this;
    }

    /**
     * Builds a new {@link RemoveUserProvidedServiceInstanceRouteRequest RemoveUserProvidedServiceInstanceRouteRequest}.
     * @return An immutable instance of RemoveUserProvidedServiceInstanceRouteRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveUserProvidedServiceInstanceRouteRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveUserProvidedServiceInstanceRouteRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ROUTE_ID) != 0) attributes.add("routeId");
      if ((initBits & INIT_BIT_USER_PROVIDED_SERVICE_INSTANCE_ID) != 0) attributes.add("userProvidedServiceInstanceId");
      return "Cannot build RemoveUserProvidedServiceInstanceRouteRequest, some of required attributes are not set " + attributes;
    }
  }
}
