package org.cloudfoundry.client.v2.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Associate Managed Space with the User operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_AssociateUserManagedSpaceRequest", generator = "Immutables")
public final class AssociateUserManagedSpaceRequest
    extends org.cloudfoundry.client.v2.users._AssociateUserManagedSpaceRequest {
  private final String managedSpaceId;
  private final String userId;

  private AssociateUserManagedSpaceRequest(AssociateUserManagedSpaceRequest.Builder builder) {
    this.managedSpaceId = builder.managedSpaceId;
    this.userId = builder.userId;
  }

  /**
   * The id of the managed space
   */
  @Override
  public String getManagedSpaceId() {
    return managedSpaceId;
  }

  /**
   * The id of the user
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * This instance is equal to all instances of {@code AssociateUserManagedSpaceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssociateUserManagedSpaceRequest
        && equalTo((AssociateUserManagedSpaceRequest) another);
  }

  private boolean equalTo(AssociateUserManagedSpaceRequest another) {
    return managedSpaceId.equals(another.managedSpaceId)
        && userId.equals(another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code managedSpaceId}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + managedSpaceId.hashCode();
    h += (h << 5) + userId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssociateUserManagedSpaceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssociateUserManagedSpaceRequest{"
        + "managedSpaceId=" + managedSpaceId
        + ", userId=" + userId
        + "}";
  }

  /**
   * Creates a builder for {@link AssociateUserManagedSpaceRequest AssociateUserManagedSpaceRequest}.
   * @return A new AssociateUserManagedSpaceRequest builder
   */
  public static AssociateUserManagedSpaceRequest.Builder builder() {
    return new AssociateUserManagedSpaceRequest.Builder();
  }

  /**
   * Builds instances of type {@link AssociateUserManagedSpaceRequest AssociateUserManagedSpaceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_MANAGED_SPACE_ID = 0x1L;
    private static final long INIT_BIT_USER_ID = 0x2L;
    private long initBits = 0x3L;

    private String managedSpaceId;
    private String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssociateUserManagedSpaceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssociateUserManagedSpaceRequest instance) {
      return from((_AssociateUserManagedSpaceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AssociateUserManagedSpaceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssociateUserManagedSpaceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      managedSpaceId(instance.getManagedSpaceId());
      userId(instance.getUserId());
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateUserManagedSpaceRequest#getManagedSpaceId() managedSpaceId} attribute.
     * @param managedSpaceId The value for managedSpaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedSpaceId(String managedSpaceId) {
      this.managedSpaceId = Objects.requireNonNull(managedSpaceId, "managedSpaceId");
      initBits &= ~INIT_BIT_MANAGED_SPACE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateUserManagedSpaceRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Builds a new {@link AssociateUserManagedSpaceRequest AssociateUserManagedSpaceRequest}.
     * @return An immutable instance of AssociateUserManagedSpaceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssociateUserManagedSpaceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AssociateUserManagedSpaceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MANAGED_SPACE_ID) != 0) attributes.add("managedSpaceId");
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build AssociateUserManagedSpaceRequest, some of required attributes are not set " + attributes;
    }
  }
}
