package org.cloudfoundry.client.v2.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Remove Space from the User operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_RemoveUserSpaceRequest", generator = "Immutables")
public final class RemoveUserSpaceRequest extends org.cloudfoundry.client.v2.users._RemoveUserSpaceRequest {
  private final String spaceId;
  private final String userId;

  private RemoveUserSpaceRequest(RemoveUserSpaceRequest.Builder builder) {
    this.spaceId = builder.spaceId;
    this.userId = builder.userId;
  }

  /**
   * The id of the space
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * The id of the user
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * This instance is equal to all instances of {@code RemoveUserSpaceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveUserSpaceRequest
        && equalTo((RemoveUserSpaceRequest) another);
  }

  private boolean equalTo(RemoveUserSpaceRequest another) {
    return spaceId.equals(another.spaceId)
        && userId.equals(another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code spaceId}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + spaceId.hashCode();
    h += (h << 5) + userId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveUserSpaceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveUserSpaceRequest{"
        + "spaceId=" + spaceId
        + ", userId=" + userId
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveUserSpaceRequest RemoveUserSpaceRequest}.
   * @return A new RemoveUserSpaceRequest builder
   */
  public static RemoveUserSpaceRequest.Builder builder() {
    return new RemoveUserSpaceRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveUserSpaceRequest RemoveUserSpaceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SPACE_ID = 0x1L;
    private static final long INIT_BIT_USER_ID = 0x2L;
    private long initBits = 0x3L;

    private String spaceId;
    private String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveUserSpaceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveUserSpaceRequest instance) {
      return from((_RemoveUserSpaceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveUserSpaceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveUserSpaceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      spaceId(instance.getSpaceId());
      userId(instance.getUserId());
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveUserSpaceRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveUserSpaceRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Builds a new {@link RemoveUserSpaceRequest RemoveUserSpaceRequest}.
     * @return An immutable instance of RemoveUserSpaceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveUserSpaceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveUserSpaceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build RemoveUserSpaceRequest, some of required attributes are not set " + attributes;
    }
  }
}
