package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.*;
import org.cloudfoundry.client.v3.Relationship;
import org.cloudfoundry.client.v3.RelationshipResponse;

/**
 * The response payload for the GetCurrent Droplet Relationship operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_GetApplicationCurrentDropletRelationshipResponse", generator = "Immutables")
public final class GetApplicationCurrentDropletRelationshipResponse
    extends org.cloudfoundry.client.v3.applications._GetApplicationCurrentDropletRelationshipResponse {
  private final @Nullable Relationship data;
  private final Map<String, Link> links;

  private GetApplicationCurrentDropletRelationshipResponse(GetApplicationCurrentDropletRelationshipResponse.Builder builder) {
    this.data = builder.data;
    this.links = createUnmodifiableMap(false, false, builder.links);
  }

  /**
   * The relationship
   */
  @JsonProperty("data")
  @Override
  public @Nullable Relationship getData() {
    return data;
  }

  /**
   * The links
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * This instance is equal to all instances of {@code GetApplicationCurrentDropletRelationshipResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetApplicationCurrentDropletRelationshipResponse
        && equalTo((GetApplicationCurrentDropletRelationshipResponse) another);
  }

  private boolean equalTo(GetApplicationCurrentDropletRelationshipResponse another) {
    return Objects.equals(data, another.data)
        && links.equals(another.links);
  }

  /**
   * Computes a hash code from attributes: {@code data}, {@code links}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(data);
    h += (h << 5) + links.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetApplicationCurrentDropletRelationshipResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetApplicationCurrentDropletRelationshipResponse{"
        + "data=" + data
        + ", links=" + links
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v3.applications._GetApplicationCurrentDropletRelationshipResponse {
    Relationship data;
    Map<String, Link> links = Collections.emptyMap();
    @JsonProperty("data")
    public void setData(@Nullable Relationship data) {
      this.data = data;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @Override
    public Relationship getData() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetApplicationCurrentDropletRelationshipResponse fromJson(Json json) {
    GetApplicationCurrentDropletRelationshipResponse.Builder builder = GetApplicationCurrentDropletRelationshipResponse.builder();
    if (json.data != null) {
      builder.data(json.data);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetApplicationCurrentDropletRelationshipResponse GetApplicationCurrentDropletRelationshipResponse}.
   * @return A new GetApplicationCurrentDropletRelationshipResponse builder
   */
  public static GetApplicationCurrentDropletRelationshipResponse.Builder builder() {
    return new GetApplicationCurrentDropletRelationshipResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetApplicationCurrentDropletRelationshipResponse GetApplicationCurrentDropletRelationshipResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Relationship data;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.RelationshipResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RelationshipResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetApplicationCurrentDropletRelationshipResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetApplicationCurrentDropletRelationshipResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetApplicationCurrentDropletRelationshipResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_GetApplicationCurrentDropletRelationshipResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof RelationshipResponse) {
        RelationshipResponse instance = (RelationshipResponse) object;
        Relationship dataValue = instance.getData();
        if (dataValue != null) {
          data(dataValue);
        }
        putAllLinks(instance.getLinks());
      }
    }

    /**
     * Initializes the value for the {@link GetApplicationCurrentDropletRelationshipResponse#getData() data} attribute.
     * @param data The value for data (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("data")
    public final Builder data(@Nullable Relationship data) {
      this.data = data;
      return this;
    }

    /**
     * Put one entry to the {@link GetApplicationCurrentDropletRelationshipResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GetApplicationCurrentDropletRelationshipResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetApplicationCurrentDropletRelationshipResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetApplicationCurrentDropletRelationshipResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link GetApplicationCurrentDropletRelationshipResponse GetApplicationCurrentDropletRelationshipResponse}.
     * @return An immutable instance of GetApplicationCurrentDropletRelationshipResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetApplicationCurrentDropletRelationshipResponse build() {
      return new GetApplicationCurrentDropletRelationshipResponse(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
