package org.cloudfoundry.client.v3.droplets;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Copy Droplet operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_CopyDropletRequest", generator = "Immutables")
public final class CopyDropletRequest extends org.cloudfoundry.client.v3.droplets._CopyDropletRequest {
  private final DropletRelationships relationships;
  private final String sourceDropletId;

  private CopyDropletRequest(CopyDropletRequest.Builder builder) {
    this.relationships = builder.relationships;
    this.sourceDropletId = builder.sourceDropletId;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public DropletRelationships getRelationships() {
    return relationships;
  }

  /**
   * The source droplet id
   */
  @JsonIgnore
  @Override
  public String getSourceDropletId() {
    return sourceDropletId;
  }

  /**
   * This instance is equal to all instances of {@code CopyDropletRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CopyDropletRequest
        && equalTo((CopyDropletRequest) another);
  }

  private boolean equalTo(CopyDropletRequest another) {
    return relationships.equals(another.relationships)
        && sourceDropletId.equals(another.sourceDropletId);
  }

  /**
   * Computes a hash code from attributes: {@code relationships}, {@code sourceDropletId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + relationships.hashCode();
    h += (h << 5) + sourceDropletId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CopyDropletRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CopyDropletRequest{"
        + "relationships=" + relationships
        + ", sourceDropletId=" + sourceDropletId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.droplets._CopyDropletRequest {
    DropletRelationships relationships;
    String sourceDropletId;
    @JsonProperty("relationships")
    public void setRelationships(DropletRelationships relationships) {
      this.relationships = relationships;
    }
    @JsonIgnore
    public void setSourceDropletId(String sourceDropletId) {
      this.sourceDropletId = sourceDropletId;
    }
    @Override
    public DropletRelationships getRelationships() { throw new UnsupportedOperationException(); }
    @Override
    public String getSourceDropletId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CopyDropletRequest fromJson(Json json) {
    CopyDropletRequest.Builder builder = CopyDropletRequest.builder();
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    if (json.sourceDropletId != null) {
      builder.sourceDropletId(json.sourceDropletId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CopyDropletRequest CopyDropletRequest}.
   * @return A new CopyDropletRequest builder
   */
  public static CopyDropletRequest.Builder builder() {
    return new CopyDropletRequest.Builder();
  }

  /**
   * Builds instances of type {@link CopyDropletRequest CopyDropletRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_RELATIONSHIPS = 0x1L;
    private static final long INIT_BIT_SOURCE_DROPLET_ID = 0x2L;
    private long initBits = 0x3L;

    private DropletRelationships relationships;
    private String sourceDropletId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CopyDropletRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CopyDropletRequest instance) {
      return from((_CopyDropletRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CopyDropletRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CopyDropletRequest instance) {
      Objects.requireNonNull(instance, "instance");
      relationships(instance.getRelationships());
      sourceDropletId(instance.getSourceDropletId());
      return this;
    }

    /**
     * Initializes the value for the {@link CopyDropletRequest#getRelationships() relationships} attribute.
     * @param relationships The value for relationships 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder relationships(DropletRelationships relationships) {
      this.relationships = Objects.requireNonNull(relationships, "relationships");
      initBits &= ~INIT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Initializes the value for the {@link CopyDropletRequest#getSourceDropletId() sourceDropletId} attribute.
     * @param sourceDropletId The value for sourceDropletId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sourceDropletId(String sourceDropletId) {
      this.sourceDropletId = Objects.requireNonNull(sourceDropletId, "sourceDropletId");
      initBits &= ~INIT_BIT_SOURCE_DROPLET_ID;
      return this;
    }

    /**
     * Builds a new {@link CopyDropletRequest CopyDropletRequest}.
     * @return An immutable instance of CopyDropletRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CopyDropletRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CopyDropletRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RELATIONSHIPS) != 0) attributes.add("relationships");
      if ((initBits & INIT_BIT_SOURCE_DROPLET_ID) != 0) attributes.add("sourceDropletId");
      return "Cannot build CopyDropletRequest, some of required attributes are not set " + attributes;
    }
  }
}
