package org.cloudfoundry.client.v3.isolationsegments;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Revoke Entitlement to Isolation Segment for an Organization operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_RemoveIsolationSegmentOrganizationEntitlementRequest", generator = "Immutables")
public final class RemoveIsolationSegmentOrganizationEntitlementRequest
    extends org.cloudfoundry.client.v3.isolationsegments._RemoveIsolationSegmentOrganizationEntitlementRequest {
  private final String isolationSegmentId;
  private final String organizationId;

  private RemoveIsolationSegmentOrganizationEntitlementRequest(RemoveIsolationSegmentOrganizationEntitlementRequest.Builder builder) {
    this.isolationSegmentId = builder.isolationSegmentId;
    this.organizationId = builder.organizationId;
  }

  /**
   * The isolation segment id
   */
  @Override
  public String getIsolationSegmentId() {
    return isolationSegmentId;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * This instance is equal to all instances of {@code RemoveIsolationSegmentOrganizationEntitlementRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveIsolationSegmentOrganizationEntitlementRequest
        && equalTo((RemoveIsolationSegmentOrganizationEntitlementRequest) another);
  }

  private boolean equalTo(RemoveIsolationSegmentOrganizationEntitlementRequest another) {
    return isolationSegmentId.equals(another.isolationSegmentId)
        && organizationId.equals(another.organizationId);
  }

  /**
   * Computes a hash code from attributes: {@code isolationSegmentId}, {@code organizationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + isolationSegmentId.hashCode();
    h += (h << 5) + organizationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveIsolationSegmentOrganizationEntitlementRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveIsolationSegmentOrganizationEntitlementRequest{"
        + "isolationSegmentId=" + isolationSegmentId
        + ", organizationId=" + organizationId
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveIsolationSegmentOrganizationEntitlementRequest RemoveIsolationSegmentOrganizationEntitlementRequest}.
   * @return A new RemoveIsolationSegmentOrganizationEntitlementRequest builder
   */
  public static RemoveIsolationSegmentOrganizationEntitlementRequest.Builder builder() {
    return new RemoveIsolationSegmentOrganizationEntitlementRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveIsolationSegmentOrganizationEntitlementRequest RemoveIsolationSegmentOrganizationEntitlementRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ISOLATION_SEGMENT_ID = 0x1L;
    private static final long INIT_BIT_ORGANIZATION_ID = 0x2L;
    private long initBits = 0x3L;

    private String isolationSegmentId;
    private String organizationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveIsolationSegmentOrganizationEntitlementRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveIsolationSegmentOrganizationEntitlementRequest instance) {
      return from((_RemoveIsolationSegmentOrganizationEntitlementRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveIsolationSegmentOrganizationEntitlementRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveIsolationSegmentOrganizationEntitlementRequest instance) {
      Objects.requireNonNull(instance, "instance");
      isolationSegmentId(instance.getIsolationSegmentId());
      organizationId(instance.getOrganizationId());
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveIsolationSegmentOrganizationEntitlementRequest#getIsolationSegmentId() isolationSegmentId} attribute.
     * @param isolationSegmentId The value for isolationSegmentId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isolationSegmentId(String isolationSegmentId) {
      this.isolationSegmentId = Objects.requireNonNull(isolationSegmentId, "isolationSegmentId");
      initBits &= ~INIT_BIT_ISOLATION_SEGMENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveIsolationSegmentOrganizationEntitlementRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Builds a new {@link RemoveIsolationSegmentOrganizationEntitlementRequest RemoveIsolationSegmentOrganizationEntitlementRequest}.
     * @return An immutable instance of RemoveIsolationSegmentOrganizationEntitlementRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveIsolationSegmentOrganizationEntitlementRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveIsolationSegmentOrganizationEntitlementRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ISOLATION_SEGMENT_ID) != 0) attributes.add("isolationSegmentId");
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build RemoveIsolationSegmentOrganizationEntitlementRequest, some of required attributes are not set " + attributes;
    }
  }
}
