package org.cloudfoundry.client.v3.packages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Copy Package operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_CopyPackageRequest", generator = "Immutables")
public final class CopyPackageRequest extends org.cloudfoundry.client.v3.packages._CopyPackageRequest {
  private final PackageRelationships relationships;
  private final String sourcePackageId;

  private CopyPackageRequest(CopyPackageRequest.Builder builder) {
    this.relationships = builder.relationships;
    this.sourcePackageId = builder.sourcePackageId;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public PackageRelationships getRelationships() {
    return relationships;
  }

  /**
   * The source package id
   */
  @JsonIgnore
  @Override
  public String getSourcePackageId() {
    return sourcePackageId;
  }

  /**
   * This instance is equal to all instances of {@code CopyPackageRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CopyPackageRequest
        && equalTo((CopyPackageRequest) another);
  }

  private boolean equalTo(CopyPackageRequest another) {
    return relationships.equals(another.relationships)
        && sourcePackageId.equals(another.sourcePackageId);
  }

  /**
   * Computes a hash code from attributes: {@code relationships}, {@code sourcePackageId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + relationships.hashCode();
    h += (h << 5) + sourcePackageId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CopyPackageRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CopyPackageRequest{"
        + "relationships=" + relationships
        + ", sourcePackageId=" + sourcePackageId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.packages._CopyPackageRequest {
    PackageRelationships relationships;
    String sourcePackageId;
    @JsonProperty("relationships")
    public void setRelationships(PackageRelationships relationships) {
      this.relationships = relationships;
    }
    @JsonIgnore
    public void setSourcePackageId(String sourcePackageId) {
      this.sourcePackageId = sourcePackageId;
    }
    @Override
    public PackageRelationships getRelationships() { throw new UnsupportedOperationException(); }
    @Override
    public String getSourcePackageId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CopyPackageRequest fromJson(Json json) {
    CopyPackageRequest.Builder builder = CopyPackageRequest.builder();
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    if (json.sourcePackageId != null) {
      builder.sourcePackageId(json.sourcePackageId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CopyPackageRequest CopyPackageRequest}.
   * @return A new CopyPackageRequest builder
   */
  public static CopyPackageRequest.Builder builder() {
    return new CopyPackageRequest.Builder();
  }

  /**
   * Builds instances of type {@link CopyPackageRequest CopyPackageRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_RELATIONSHIPS = 0x1L;
    private static final long INIT_BIT_SOURCE_PACKAGE_ID = 0x2L;
    private long initBits = 0x3L;

    private PackageRelationships relationships;
    private String sourcePackageId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CopyPackageRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CopyPackageRequest instance) {
      return from((_CopyPackageRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CopyPackageRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CopyPackageRequest instance) {
      Objects.requireNonNull(instance, "instance");
      relationships(instance.getRelationships());
      sourcePackageId(instance.getSourcePackageId());
      return this;
    }

    /**
     * Initializes the value for the {@link CopyPackageRequest#getRelationships() relationships} attribute.
     * @param relationships The value for relationships 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder relationships(PackageRelationships relationships) {
      this.relationships = Objects.requireNonNull(relationships, "relationships");
      initBits &= ~INIT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Initializes the value for the {@link CopyPackageRequest#getSourcePackageId() sourcePackageId} attribute.
     * @param sourcePackageId The value for sourcePackageId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sourcePackageId(String sourcePackageId) {
      this.sourcePackageId = Objects.requireNonNull(sourcePackageId, "sourcePackageId");
      initBits &= ~INIT_BIT_SOURCE_PACKAGE_ID;
      return this;
    }

    /**
     * Builds a new {@link CopyPackageRequest CopyPackageRequest}.
     * @return An immutable instance of CopyPackageRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CopyPackageRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CopyPackageRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RELATIONSHIPS) != 0) attributes.add("relationships");
      if ((initBits & INIT_BIT_SOURCE_PACKAGE_ID) != 0) attributes.add("sourcePackageId");
      return "Cannot build CopyPackageRequest, some of required attributes are not set " + attributes;
    }
  }
}
