package org.cloudfoundry.client.v3.servicebindings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;

/**
 * The request payload for the List Service Bindings operation.
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_ListServiceBindingsRequest", generator = "Immutables")
public final class ListServiceBindingsRequest
    extends org.cloudfoundry.client.v3.servicebindings._ListServiceBindingsRequest {
  private final List<String> applicationIds;
  private final List<String> serviceInstanceIds;
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;

  private ListServiceBindingsRequest(ListServiceBindingsRequest.Builder builder) {
    this.applicationIds = createUnmodifiableList(true, builder.applicationIds);
    this.serviceInstanceIds = createUnmodifiableList(true, builder.serviceInstanceIds);
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
  }

  /**
   * The application ids
   */
  @Override
  public List<String> getApplicationIds() {
    return applicationIds;
  }

  /**
   * The service instance ids
   */
  @Override
  public List<String> getServiceInstanceIds() {
    return serviceInstanceIds;
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * This instance is equal to all instances of {@code ListServiceBindingsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListServiceBindingsRequest
        && equalTo((ListServiceBindingsRequest) another);
  }

  private boolean equalTo(ListServiceBindingsRequest another) {
    return applicationIds.equals(another.applicationIds)
        && serviceInstanceIds.equals(another.serviceInstanceIds)
        && Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage);
  }

  /**
   * Computes a hash code from attributes: {@code applicationIds}, {@code serviceInstanceIds}, {@code orderBy}, {@code page}, {@code perPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationIds.hashCode();
    h += (h << 5) + serviceInstanceIds.hashCode();
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListServiceBindingsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListServiceBindingsRequest{"
        + "applicationIds=" + applicationIds
        + ", serviceInstanceIds=" + serviceInstanceIds
        + ", orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListServiceBindingsRequest ListServiceBindingsRequest}.
   * @return A new ListServiceBindingsRequest builder
   */
  public static ListServiceBindingsRequest.Builder builder() {
    return new ListServiceBindingsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListServiceBindingsRequest ListServiceBindingsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<String> applicationIds = new ArrayList<String>();
    private List<String> serviceInstanceIds = new ArrayList<String>();
    private String orderBy;
    private Integer page;
    private Integer perPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListServiceBindingsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListServiceBindingsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListServiceBindingsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListServiceBindingsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.servicebindings._ListServiceBindingsRequest) {
        org.cloudfoundry.client.v3.servicebindings._ListServiceBindingsRequest instance = (org.cloudfoundry.client.v3.servicebindings._ListServiceBindingsRequest) object;
        addAllServiceInstanceIds(instance.getServiceInstanceIds());
        addAllApplicationIds(instance.getApplicationIds());
      }
    }

    /**
     * Adds one element to {@link ListServiceBindingsRequest#getApplicationIds() applicationIds} list.
     * @param element A applicationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String element) {
      this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getApplicationIds() applicationIds} list.
     * @param elements An array of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(String... elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceBindingsRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(Iterable<String> elements) {
      this.applicationIds.clear();
      return addAllApplicationIds(elements);
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplicationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServiceBindingsRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param element A serviceInstanceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceId(String element) {
      this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param elements An array of serviceInstanceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceIds(String... elements) {
      for (String element : elements) {
        this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceBindingsRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param elements An iterable of serviceInstanceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceIds(Iterable<String> elements) {
      this.serviceInstanceIds.clear();
      return addAllServiceInstanceIds(elements);
    }

    /**
     * Adds elements to {@link ListServiceBindingsRequest#getServiceInstanceIds() serviceInstanceIds} list.
     * @param elements An iterable of serviceInstanceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceInstanceIds(Iterable<String> elements) {
      for (String element : elements) {
        this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceBindingsRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceBindingsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceBindingsRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Builds a new {@link ListServiceBindingsRequest ListServiceBindingsRequest}.
     * @return An immutable instance of ListServiceBindingsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListServiceBindingsRequest build() {
      return new ListServiceBindingsRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
