package org.cloudfoundry.doppler;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Firehose endpoint
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_FirehoseRequest", generator = "Immutables")
public final class FirehoseRequest extends org.cloudfoundry.doppler._FirehoseRequest {
  private final String subscriptionId;

  private FirehoseRequest(FirehoseRequest.Builder builder) {
    this.subscriptionId = builder.subscriptionId;
  }

  /**
   * The subscription id
   */
  @Override
  public String getSubscriptionId() {
    return subscriptionId;
  }

  /**
   * This instance is equal to all instances of {@code FirehoseRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof FirehoseRequest
        && equalTo((FirehoseRequest) another);
  }

  private boolean equalTo(FirehoseRequest another) {
    return subscriptionId.equals(another.subscriptionId);
  }

  /**
   * Computes a hash code from attributes: {@code subscriptionId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + subscriptionId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FirehoseRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FirehoseRequest{"
        + "subscriptionId=" + subscriptionId
        + "}";
  }

  /**
   * Creates a builder for {@link FirehoseRequest FirehoseRequest}.
   * @return A new FirehoseRequest builder
   */
  public static FirehoseRequest.Builder builder() {
    return new FirehoseRequest.Builder();
  }

  /**
   * Builds instances of type {@link FirehoseRequest FirehoseRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SUBSCRIPTION_ID = 0x1L;
    private long initBits = 0x1L;

    private String subscriptionId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FirehoseRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FirehoseRequest instance) {
      return from((_FirehoseRequest) instance);
    }

    /**
     * Copy abstract value type {@code _FirehoseRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_FirehoseRequest instance) {
      Objects.requireNonNull(instance, "instance");
      subscriptionId(instance.getSubscriptionId());
      return this;
    }

    /**
     * Initializes the value for the {@link FirehoseRequest#getSubscriptionId() subscriptionId} attribute.
     * @param subscriptionId The value for subscriptionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder subscriptionId(String subscriptionId) {
      this.subscriptionId = Objects.requireNonNull(subscriptionId, "subscriptionId");
      initBits &= ~INIT_BIT_SUBSCRIPTION_ID;
      return this;
    }

    /**
     * Builds a new {@link FirehoseRequest FirehoseRequest}.
     * @return An immutable instance of FirehoseRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public FirehoseRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new FirehoseRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SUBSCRIPTION_ID) != 0) attributes.add("subscriptionId");
      return "Cannot build FirehoseRequest, some of required attributes are not set " + attributes;
    }
  }
}
