package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.tokens.GrantType;

/**
 * The request payload for the create client
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_CreateClientRequest", generator = "Immutables")
public final class CreateClientRequest extends org.cloudfoundry.uaa.clients._CreateClientRequest {
  private final @Nullable Long accessTokenValidity;
  private final @Nullable List<String> allowedProviders;
  private final @Nullable Boolean approvalsDeleted;
  private final @Nullable List<String> authorities;
  private final @Nullable List<GrantType> authorizedGrantTypes;
  private final @Nullable List<String> autoApproves;
  private final String clientId;
  private final @Nullable String clientSecret;
  private final @Nullable String createdWith;
  private final @Nullable String name;
  private final @Nullable List<String> redirectUriPatterns;
  private final @Nullable Long refreshTokenValidity;
  private final @Nullable List<String> resourceIds;
  private final @Nullable List<String> scopes;
  private final @Nullable String tokenSalt;
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;

  private CreateClientRequest(CreateClientRequest.Builder builder) {
    this.accessTokenValidity = builder.accessTokenValidity;
    this.allowedProviders = builder.allowedProviders == null ? null : createUnmodifiableList(true, builder.allowedProviders);
    this.approvalsDeleted = builder.approvalsDeleted;
    this.authorities = builder.authorities == null ? null : createUnmodifiableList(true, builder.authorities);
    this.authorizedGrantTypes = builder.authorizedGrantTypes == null ? null : createUnmodifiableList(true, builder.authorizedGrantTypes);
    this.autoApproves = builder.autoApproves == null ? null : createUnmodifiableList(true, builder.autoApproves);
    this.clientId = builder.clientId;
    this.clientSecret = builder.clientSecret;
    this.createdWith = builder.createdWith;
    this.name = builder.name;
    this.redirectUriPatterns = builder.redirectUriPatterns == null ? null : createUnmodifiableList(true, builder.redirectUriPatterns);
    this.refreshTokenValidity = builder.refreshTokenValidity;
    this.resourceIds = builder.resourceIds == null ? null : createUnmodifiableList(true, builder.resourceIds);
    this.scopes = builder.scopes == null ? null : createUnmodifiableList(true, builder.scopes);
    this.tokenSalt = builder.tokenSalt;
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
  }

  /**
   * The access token validity
   */
  @JsonProperty("access_token_validity")
  @Override
  public @Nullable Long getAccessTokenValidity() {
    return accessTokenValidity;
  }

  /**
   * A list of origin keys (alias) for identity providers the client is limited to. Null implies any identity provider is allowed.
   */
  @JsonProperty("allowedproviders")
  @Override
  public @Nullable List<String> getAllowedProviders() {
    return allowedProviders;
  }

  /**
   * Were the approvals deleted for the client, and an audit event sent
   */
  @JsonProperty("approvals_deleted")
  @Override
  public @Nullable Boolean getApprovalsDeleted() {
    return approvalsDeleted;
  }

  /**
   * Scopes that the client is able to grant when creating a client
   */
  @JsonProperty("authorities")
  @Override
  public @Nullable List<String> getAuthorities() {
    return authorities;
  }

  /**
   * List of grant types that can be used to obtain a token with this client. Can include authorization_code, password, implicit, and/or client_credentials.
   */
  @JsonProperty("authorized_grant_types")
  @Override
  public @Nullable List<GrantType> getAuthorizedGrantTypes() {
    return authorizedGrantTypes;
  }

  /**
   * Scopes that do not require user approval
   */
  @JsonProperty("autoapprove")
  @Override
  public @Nullable List<String> getAutoApproves() {
    return autoApproves;
  }

  /**
   * Client identifier, unique within identity zone
   */
  @JsonProperty("client_id")
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * A secret string used for authenticating as this client
   */
  @JsonProperty("client_secret")
  @Override
  public @Nullable String getClientSecret() {
    return clientSecret;
  }

  /**
   * What scope the bearer token had when client was created
   */
  @JsonProperty("createdwith")
  @Override
  public @Nullable String getCreatedWith() {
    return createdWith;
  }

  /**
   * A human readable name for the client
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * Allowed URI pattern for redirect during authorization
   */
  @JsonProperty("redirect_uri")
  @Override
  public @Nullable List<String> getRedirectUriPatterns() {
    return redirectUriPatterns;
  }

  /**
   * The refresh token validity
   */
  @JsonProperty("refresh_token_validity")
  @Override
  public @Nullable Long getRefreshTokenValidity() {
    return refreshTokenValidity;
  }

  /**
   * Resources the client is allowed access to
   */
  @JsonProperty("resource_ids")
  @Override
  public @Nullable List<String> getResourceIds() {
    return resourceIds;
  }

  /**
   * Scopes allowed for the client
   */
  @JsonProperty("scope")
  @Override
  public @Nullable List<String> getScopes() {
    return scopes;
  }

  /**
   * A random string used to generate the client’s revokation key. Change this value to revoke all active tokens for the client
   */
  @JsonProperty("token_salt")
  @Override
  public @Nullable String getTokenSalt() {
    return tokenSalt;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @JsonProperty("identityZoneId")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @JsonProperty("identityZoneSubdomain")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * This instance is equal to all instances of {@code CreateClientRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateClientRequest
        && equalTo((CreateClientRequest) another);
  }

  private boolean equalTo(CreateClientRequest another) {
    return Objects.equals(accessTokenValidity, another.accessTokenValidity)
        && Objects.equals(allowedProviders, another.allowedProviders)
        && Objects.equals(approvalsDeleted, another.approvalsDeleted)
        && Objects.equals(authorities, another.authorities)
        && Objects.equals(authorizedGrantTypes, another.authorizedGrantTypes)
        && Objects.equals(autoApproves, another.autoApproves)
        && clientId.equals(another.clientId)
        && Objects.equals(clientSecret, another.clientSecret)
        && Objects.equals(createdWith, another.createdWith)
        && Objects.equals(name, another.name)
        && Objects.equals(redirectUriPatterns, another.redirectUriPatterns)
        && Objects.equals(refreshTokenValidity, another.refreshTokenValidity)
        && Objects.equals(resourceIds, another.resourceIds)
        && Objects.equals(scopes, another.scopes)
        && Objects.equals(tokenSalt, another.tokenSalt)
        && Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain);
  }

  /**
   * Computes a hash code from attributes: {@code accessTokenValidity}, {@code allowedProviders}, {@code approvalsDeleted}, {@code authorities}, {@code authorizedGrantTypes}, {@code autoApproves}, {@code clientId}, {@code clientSecret}, {@code createdWith}, {@code name}, {@code redirectUriPatterns}, {@code refreshTokenValidity}, {@code resourceIds}, {@code scopes}, {@code tokenSalt}, {@code identityZoneId}, {@code identityZoneSubdomain}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(accessTokenValidity);
    h += (h << 5) + Objects.hashCode(allowedProviders);
    h += (h << 5) + Objects.hashCode(approvalsDeleted);
    h += (h << 5) + Objects.hashCode(authorities);
    h += (h << 5) + Objects.hashCode(authorizedGrantTypes);
    h += (h << 5) + Objects.hashCode(autoApproves);
    h += (h << 5) + clientId.hashCode();
    h += (h << 5) + Objects.hashCode(clientSecret);
    h += (h << 5) + Objects.hashCode(createdWith);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(redirectUriPatterns);
    h += (h << 5) + Objects.hashCode(refreshTokenValidity);
    h += (h << 5) + Objects.hashCode(resourceIds);
    h += (h << 5) + Objects.hashCode(scopes);
    h += (h << 5) + Objects.hashCode(tokenSalt);
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateClientRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateClientRequest{"
        + "accessTokenValidity=" + accessTokenValidity
        + ", allowedProviders=" + allowedProviders
        + ", approvalsDeleted=" + approvalsDeleted
        + ", authorities=" + authorities
        + ", authorizedGrantTypes=" + authorizedGrantTypes
        + ", autoApproves=" + autoApproves
        + ", clientId=" + clientId
        + ", clientSecret=" + clientSecret
        + ", createdWith=" + createdWith
        + ", name=" + name
        + ", redirectUriPatterns=" + redirectUriPatterns
        + ", refreshTokenValidity=" + refreshTokenValidity
        + ", resourceIds=" + resourceIds
        + ", scopes=" + scopes
        + ", tokenSalt=" + tokenSalt
        + ", identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.clients._CreateClientRequest {
    Long accessTokenValidity;
    List<String> allowedProviders = null;
    Boolean approvalsDeleted;
    List<String> authorities = null;
    List<GrantType> authorizedGrantTypes = null;
    List<String> autoApproves = null;
    String clientId;
    String clientSecret;
    String createdWith;
    String name;
    List<String> redirectUriPatterns = null;
    Long refreshTokenValidity;
    List<String> resourceIds = null;
    List<String> scopes = null;
    String tokenSalt;
    String identityZoneId;
    String identityZoneSubdomain;
    @JsonProperty("access_token_validity")
    public void setAccessTokenValidity(@Nullable Long accessTokenValidity) {
      this.accessTokenValidity = accessTokenValidity;
    }
    @JsonProperty("allowedproviders")
    public void setAllowedProviders(@Nullable List<String> allowedProviders) {
      this.allowedProviders = allowedProviders;
    }
    @JsonProperty("approvals_deleted")
    public void setApprovalsDeleted(@Nullable Boolean approvalsDeleted) {
      this.approvalsDeleted = approvalsDeleted;
    }
    @JsonProperty("authorities")
    public void setAuthorities(@Nullable List<String> authorities) {
      this.authorities = authorities;
    }
    @JsonProperty("authorized_grant_types")
    public void setAuthorizedGrantTypes(@Nullable List<GrantType> authorizedGrantTypes) {
      this.authorizedGrantTypes = authorizedGrantTypes;
    }
    @JsonProperty("autoapprove")
    public void setAutoApproves(@Nullable List<String> autoApproves) {
      this.autoApproves = autoApproves;
    }
    @JsonProperty("client_id")
    public void setClientId(String clientId) {
      this.clientId = clientId;
    }
    @JsonProperty("client_secret")
    public void setClientSecret(@Nullable String clientSecret) {
      this.clientSecret = clientSecret;
    }
    @JsonProperty("createdwith")
    public void setCreatedWith(@Nullable String createdWith) {
      this.createdWith = createdWith;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("redirect_uri")
    public void setRedirectUriPatterns(@Nullable List<String> redirectUriPatterns) {
      this.redirectUriPatterns = redirectUriPatterns;
    }
    @JsonProperty("refresh_token_validity")
    public void setRefreshTokenValidity(@Nullable Long refreshTokenValidity) {
      this.refreshTokenValidity = refreshTokenValidity;
    }
    @JsonProperty("resource_ids")
    public void setResourceIds(@Nullable List<String> resourceIds) {
      this.resourceIds = resourceIds;
    }
    @JsonProperty("scope")
    public void setScopes(@Nullable List<String> scopes) {
      this.scopes = scopes;
    }
    @JsonProperty("token_salt")
    public void setTokenSalt(@Nullable String tokenSalt) {
      this.tokenSalt = tokenSalt;
    }
    @JsonProperty("identityZoneId")
    @JsonIgnore
    public void setIdentityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
    }
    @JsonProperty("identityZoneSubdomain")
    @JsonIgnore
    public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
    }
    @Override
    public Long getAccessTokenValidity() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getAllowedProviders() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getApprovalsDeleted() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getAuthorities() { throw new UnsupportedOperationException(); }
    @Override
    public List<GrantType> getAuthorizedGrantTypes() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getAutoApproves() { throw new UnsupportedOperationException(); }
    @Override
    public String getClientId() { throw new UnsupportedOperationException(); }
    @Override
    public String getClientSecret() { throw new UnsupportedOperationException(); }
    @Override
    public String getCreatedWith() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getRedirectUriPatterns() { throw new UnsupportedOperationException(); }
    @Override
    public Long getRefreshTokenValidity() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getResourceIds() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getScopes() { throw new UnsupportedOperationException(); }
    @Override
    public String getTokenSalt() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneSubdomain() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateClientRequest fromJson(Json json) {
    CreateClientRequest.Builder builder = CreateClientRequest.builder();
    if (json.accessTokenValidity != null) {
      builder.accessTokenValidity(json.accessTokenValidity);
    }
    if (json.allowedProviders != null) {
      builder.addAllAllowedProviders(json.allowedProviders);
    }
    if (json.approvalsDeleted != null) {
      builder.approvalsDeleted(json.approvalsDeleted);
    }
    if (json.authorities != null) {
      builder.addAllAuthorities(json.authorities);
    }
    if (json.authorizedGrantTypes != null) {
      builder.addAllAuthorizedGrantTypes(json.authorizedGrantTypes);
    }
    if (json.autoApproves != null) {
      builder.addAllAutoApproves(json.autoApproves);
    }
    if (json.clientId != null) {
      builder.clientId(json.clientId);
    }
    if (json.clientSecret != null) {
      builder.clientSecret(json.clientSecret);
    }
    if (json.createdWith != null) {
      builder.createdWith(json.createdWith);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.redirectUriPatterns != null) {
      builder.addAllRedirectUriPatterns(json.redirectUriPatterns);
    }
    if (json.refreshTokenValidity != null) {
      builder.refreshTokenValidity(json.refreshTokenValidity);
    }
    if (json.resourceIds != null) {
      builder.addAllResourceIds(json.resourceIds);
    }
    if (json.scopes != null) {
      builder.addAllScopes(json.scopes);
    }
    if (json.tokenSalt != null) {
      builder.tokenSalt(json.tokenSalt);
    }
    if (json.identityZoneId != null) {
      builder.identityZoneId(json.identityZoneId);
    }
    if (json.identityZoneSubdomain != null) {
      builder.identityZoneSubdomain(json.identityZoneSubdomain);
    }
    return builder.build();
  }


  private static CreateClientRequest validate(CreateClientRequest instance) {
    instance.checkAuthorizedGrantTypes();
    return instance;
  }

  /**
   * Creates a builder for {@link CreateClientRequest CreateClientRequest}.
   * @return A new CreateClientRequest builder
   */
  public static CreateClientRequest.Builder builder() {
    return new CreateClientRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateClientRequest CreateClientRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_CLIENT_ID = 0x1L;
    private long initBits = 0x1L;

    private Long accessTokenValidity;
    private List<String> allowedProviders = null;
    private Boolean approvalsDeleted;
    private List<String> authorities = null;
    private List<GrantType> authorizedGrantTypes = null;
    private List<String> autoApproves = null;
    private String clientId;
    private String clientSecret;
    private String createdWith;
    private String name;
    private List<String> redirectUriPatterns = null;
    private Long refreshTokenValidity;
    private List<String> resourceIds = null;
    private List<String> scopes = null;
    private String tokenSalt;
    private String identityZoneId;
    private String identityZoneSubdomain;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.clients.AbstractCreateClient} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractCreateClient instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateClientRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateClientRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _CreateClientRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_CreateClientRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof AbstractCreateClient) {
        AbstractCreateClient instance = (AbstractCreateClient) object;
        List<GrantType> authorizedGrantTypesValue = instance.getAuthorizedGrantTypes();
        if (authorizedGrantTypesValue != null) {
          addAllAuthorizedGrantTypes(authorizedGrantTypesValue);
        }
        String tokenSaltValue = instance.getTokenSalt();
        if (tokenSaltValue != null) {
          tokenSalt(tokenSaltValue);
        }
        clientId(instance.getClientId());
        String createdWithValue = instance.getCreatedWith();
        if (createdWithValue != null) {
          createdWith(createdWithValue);
        }
        List<String> redirectUriPatternsValue = instance.getRedirectUriPatterns();
        if (redirectUriPatternsValue != null) {
          addAllRedirectUriPatterns(redirectUriPatternsValue);
        }
        Long accessTokenValidityValue = instance.getAccessTokenValidity();
        if (accessTokenValidityValue != null) {
          accessTokenValidity(accessTokenValidityValue);
        }
        List<String> authoritiesValue = instance.getAuthorities();
        if (authoritiesValue != null) {
          addAllAuthorities(authoritiesValue);
        }
        Long refreshTokenValidityValue = instance.getRefreshTokenValidity();
        if (refreshTokenValidityValue != null) {
          refreshTokenValidity(refreshTokenValidityValue);
        }
        String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        String clientSecretValue = instance.getClientSecret();
        if (clientSecretValue != null) {
          clientSecret(clientSecretValue);
        }
        Boolean approvalsDeletedValue = instance.getApprovalsDeleted();
        if (approvalsDeletedValue != null) {
          approvalsDeleted(approvalsDeletedValue);
        }
        List<String> scopesValue = instance.getScopes();
        if (scopesValue != null) {
          addAllScopes(scopesValue);
        }
        List<String> autoApprovesValue = instance.getAutoApproves();
        if (autoApprovesValue != null) {
          addAllAutoApproves(autoApprovesValue);
        }
        List<String> allowedProvidersValue = instance.getAllowedProviders();
        if (allowedProvidersValue != null) {
          addAllAllowedProviders(allowedProvidersValue);
        }
        List<String> resourceIdsValue = instance.getResourceIds();
        if (resourceIdsValue != null) {
          addAllResourceIds(resourceIdsValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link CreateClientRequest#getAccessTokenValidity() accessTokenValidity} attribute.
     * @param accessTokenValidity The value for accessTokenValidity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder accessTokenValidity(@Nullable Long accessTokenValidity) {
      this.accessTokenValidity = accessTokenValidity;
      return this;
    }

    /**
     * Adds one element to {@link CreateClientRequest#getAllowedProviders() allowedProviders} list.
     * @param element A allowedProviders element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedProvider(String element) {
      if (this.allowedProviders == null) {
        this.allowedProviders = new ArrayList<String>();
      }
      this.allowedProviders.add(Objects.requireNonNull(element, "allowedProviders element"));
      return this;
    }

    /**
     * Adds elements to {@link CreateClientRequest#getAllowedProviders() allowedProviders} list.
     * @param elements An array of allowedProviders elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedProviders(String... elements) {
      if (this.allowedProviders == null) {
        this.allowedProviders = new ArrayList<String>();
      }
      for (String element : elements) {
        this.allowedProviders.add(Objects.requireNonNull(element, "allowedProviders element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateClientRequest#getAllowedProviders() allowedProviders} list.
     * @param elements An iterable of allowedProviders elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedProviders(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.allowedProviders = null;
        return this;
      }
      this.allowedProviders = new ArrayList<String>();
      return addAllAllowedProviders(elements);
    }

    /**
     * Adds elements to {@link CreateClientRequest#getAllowedProviders() allowedProviders} list.
     * @param elements An iterable of allowedProviders elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAllowedProviders(Iterable<String> elements) {
      Objects.requireNonNull(elements, "allowedProviders element");
      if (this.allowedProviders == null) {
        this.allowedProviders = new ArrayList<String>();
      }
      for (String element : elements) {
        this.allowedProviders.add(Objects.requireNonNull(element, "allowedProviders element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateClientRequest#getApprovalsDeleted() approvalsDeleted} attribute.
     * @param approvalsDeleted The value for approvalsDeleted (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder approvalsDeleted(@Nullable Boolean approvalsDeleted) {
      this.approvalsDeleted = approvalsDeleted;
      return this;
    }

    /**
     * Adds one element to {@link CreateClientRequest#getAuthorities() authorities} list.
     * @param element A authorities element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authority(String element) {
      if (this.authorities == null) {
        this.authorities = new ArrayList<String>();
      }
      this.authorities.add(Objects.requireNonNull(element, "authorities element"));
      return this;
    }

    /**
     * Adds elements to {@link CreateClientRequest#getAuthorities() authorities} list.
     * @param elements An array of authorities elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authorities(String... elements) {
      if (this.authorities == null) {
        this.authorities = new ArrayList<String>();
      }
      for (String element : elements) {
        this.authorities.add(Objects.requireNonNull(element, "authorities element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateClientRequest#getAuthorities() authorities} list.
     * @param elements An iterable of authorities elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authorities(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.authorities = null;
        return this;
      }
      this.authorities = new ArrayList<String>();
      return addAllAuthorities(elements);
    }

    /**
     * Adds elements to {@link CreateClientRequest#getAuthorities() authorities} list.
     * @param elements An iterable of authorities elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAuthorities(Iterable<String> elements) {
      Objects.requireNonNull(elements, "authorities element");
      if (this.authorities == null) {
        this.authorities = new ArrayList<String>();
      }
      for (String element : elements) {
        this.authorities.add(Objects.requireNonNull(element, "authorities element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link CreateClientRequest#getAuthorizedGrantTypes() authorizedGrantTypes} list.
     * @param element A authorizedGrantTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authorizedGrantType(GrantType element) {
      if (this.authorizedGrantTypes == null) {
        this.authorizedGrantTypes = new ArrayList<GrantType>();
      }
      this.authorizedGrantTypes.add(Objects.requireNonNull(element, "authorizedGrantTypes element"));
      return this;
    }

    /**
     * Adds elements to {@link CreateClientRequest#getAuthorizedGrantTypes() authorizedGrantTypes} list.
     * @param elements An array of authorizedGrantTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authorizedGrantTypes(GrantType... elements) {
      if (this.authorizedGrantTypes == null) {
        this.authorizedGrantTypes = new ArrayList<GrantType>();
      }
      for (GrantType element : elements) {
        this.authorizedGrantTypes.add(Objects.requireNonNull(element, "authorizedGrantTypes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateClientRequest#getAuthorizedGrantTypes() authorizedGrantTypes} list.
     * @param elements An iterable of authorizedGrantTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authorizedGrantTypes(@Nullable Iterable<? extends GrantType> elements) {
      if (elements == null) {
        this.authorizedGrantTypes = null;
        return this;
      }
      this.authorizedGrantTypes = new ArrayList<GrantType>();
      return addAllAuthorizedGrantTypes(elements);
    }

    /**
     * Adds elements to {@link CreateClientRequest#getAuthorizedGrantTypes() authorizedGrantTypes} list.
     * @param elements An iterable of authorizedGrantTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAuthorizedGrantTypes(Iterable<? extends GrantType> elements) {
      Objects.requireNonNull(elements, "authorizedGrantTypes element");
      if (this.authorizedGrantTypes == null) {
        this.authorizedGrantTypes = new ArrayList<GrantType>();
      }
      for (GrantType element : elements) {
        this.authorizedGrantTypes.add(Objects.requireNonNull(element, "authorizedGrantTypes element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link CreateClientRequest#getAutoApproves() autoApproves} list.
     * @param element A autoApproves element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder autoApprove(String element) {
      if (this.autoApproves == null) {
        this.autoApproves = new ArrayList<String>();
      }
      this.autoApproves.add(Objects.requireNonNull(element, "autoApproves element"));
      return this;
    }

    /**
     * Adds elements to {@link CreateClientRequest#getAutoApproves() autoApproves} list.
     * @param elements An array of autoApproves elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder autoApproves(String... elements) {
      if (this.autoApproves == null) {
        this.autoApproves = new ArrayList<String>();
      }
      for (String element : elements) {
        this.autoApproves.add(Objects.requireNonNull(element, "autoApproves element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateClientRequest#getAutoApproves() autoApproves} list.
     * @param elements An iterable of autoApproves elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder autoApproves(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.autoApproves = null;
        return this;
      }
      this.autoApproves = new ArrayList<String>();
      return addAllAutoApproves(elements);
    }

    /**
     * Adds elements to {@link CreateClientRequest#getAutoApproves() autoApproves} list.
     * @param elements An iterable of autoApproves elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAutoApproves(Iterable<String> elements) {
      Objects.requireNonNull(elements, "autoApproves element");
      if (this.autoApproves == null) {
        this.autoApproves = new ArrayList<String>();
      }
      for (String element : elements) {
        this.autoApproves.add(Objects.requireNonNull(element, "autoApproves element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateClientRequest#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateClientRequest#getClientSecret() clientSecret} attribute.
     * @param clientSecret The value for clientSecret (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientSecret(@Nullable String clientSecret) {
      this.clientSecret = clientSecret;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateClientRequest#getCreatedWith() createdWith} attribute.
     * @param createdWith The value for createdWith (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder createdWith(@Nullable String createdWith) {
      this.createdWith = createdWith;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateClientRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Adds one element to {@link CreateClientRequest#getRedirectUriPatterns() redirectUriPatterns} list.
     * @param element A redirectUriPatterns element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder redirectUriPattern(String element) {
      if (this.redirectUriPatterns == null) {
        this.redirectUriPatterns = new ArrayList<String>();
      }
      this.redirectUriPatterns.add(Objects.requireNonNull(element, "redirectUriPatterns element"));
      return this;
    }

    /**
     * Adds elements to {@link CreateClientRequest#getRedirectUriPatterns() redirectUriPatterns} list.
     * @param elements An array of redirectUriPatterns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder redirectUriPatterns(String... elements) {
      if (this.redirectUriPatterns == null) {
        this.redirectUriPatterns = new ArrayList<String>();
      }
      for (String element : elements) {
        this.redirectUriPatterns.add(Objects.requireNonNull(element, "redirectUriPatterns element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateClientRequest#getRedirectUriPatterns() redirectUriPatterns} list.
     * @param elements An iterable of redirectUriPatterns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder redirectUriPatterns(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.redirectUriPatterns = null;
        return this;
      }
      this.redirectUriPatterns = new ArrayList<String>();
      return addAllRedirectUriPatterns(elements);
    }

    /**
     * Adds elements to {@link CreateClientRequest#getRedirectUriPatterns() redirectUriPatterns} list.
     * @param elements An iterable of redirectUriPatterns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRedirectUriPatterns(Iterable<String> elements) {
      Objects.requireNonNull(elements, "redirectUriPatterns element");
      if (this.redirectUriPatterns == null) {
        this.redirectUriPatterns = new ArrayList<String>();
      }
      for (String element : elements) {
        this.redirectUriPatterns.add(Objects.requireNonNull(element, "redirectUriPatterns element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateClientRequest#getRefreshTokenValidity() refreshTokenValidity} attribute.
     * @param refreshTokenValidity The value for refreshTokenValidity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder refreshTokenValidity(@Nullable Long refreshTokenValidity) {
      this.refreshTokenValidity = refreshTokenValidity;
      return this;
    }

    /**
     * Adds one element to {@link CreateClientRequest#getResourceIds() resourceIds} list.
     * @param element A resourceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resourceId(String element) {
      if (this.resourceIds == null) {
        this.resourceIds = new ArrayList<String>();
      }
      this.resourceIds.add(Objects.requireNonNull(element, "resourceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link CreateClientRequest#getResourceIds() resourceIds} list.
     * @param elements An array of resourceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resourceIds(String... elements) {
      if (this.resourceIds == null) {
        this.resourceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.resourceIds.add(Objects.requireNonNull(element, "resourceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateClientRequest#getResourceIds() resourceIds} list.
     * @param elements An iterable of resourceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resourceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.resourceIds = null;
        return this;
      }
      this.resourceIds = new ArrayList<String>();
      return addAllResourceIds(elements);
    }

    /**
     * Adds elements to {@link CreateClientRequest#getResourceIds() resourceIds} list.
     * @param elements An iterable of resourceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllResourceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "resourceIds element");
      if (this.resourceIds == null) {
        this.resourceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.resourceIds.add(Objects.requireNonNull(element, "resourceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link CreateClientRequest#getScopes() scopes} list.
     * @param element A scopes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scope(String element) {
      if (this.scopes == null) {
        this.scopes = new ArrayList<String>();
      }
      this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      return this;
    }

    /**
     * Adds elements to {@link CreateClientRequest#getScopes() scopes} list.
     * @param elements An array of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scopes(String... elements) {
      if (this.scopes == null) {
        this.scopes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateClientRequest#getScopes() scopes} list.
     * @param elements An iterable of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scopes(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.scopes = null;
        return this;
      }
      this.scopes = new ArrayList<String>();
      return addAllScopes(elements);
    }

    /**
     * Adds elements to {@link CreateClientRequest#getScopes() scopes} list.
     * @param elements An iterable of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllScopes(Iterable<String> elements) {
      Objects.requireNonNull(elements, "scopes element");
      if (this.scopes == null) {
        this.scopes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateClientRequest#getTokenSalt() tokenSalt} attribute.
     * @param tokenSalt The value for tokenSalt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tokenSalt(@Nullable String tokenSalt) {
      this.tokenSalt = tokenSalt;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateClientRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateClientRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Builds a new {@link CreateClientRequest CreateClientRequest}.
     * @return An immutable instance of CreateClientRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateClientRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return CreateClientRequest.validate(new CreateClientRequest(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      return "Cannot build CreateClientRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
